import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiBasicTable } from '../basic_table';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiHealth } from '../health';
import { EuiSpacer } from '../spacer';
import { EuiSearchBar } from './search_bar';
import { jsx as ___EmotionJSX } from "@emotion/react";
var tags = [{
  name: 'marketing',
  color: 'danger'
}, {
  name: 'finance',
  color: 'success'
}, {
  name: 'eng',
  color: 'success'
}, {
  name: 'sales',
  color: 'warning'
}, {
  name: 'ga',
  color: 'success'
}];
var tagsMap = tags.map(function (tag) {
  return {
    value: tag.name,
    view: ___EmotionJSX(EuiHealth, {
      color: tag.color
    }, tag.name)
  };
});
var items = [{
  type: 'Dashboard',
  id: 1,
  status: 'Open',
  tag: ['finance', 'sales', 'marketing'],
  owner: 'Dewey'
}, {
  type: 'Visualization',
  id: 2,
  status: 'Open',
  tag: ['finance'],
  owner: 'Wanda'
}, {
  type: 'Dashboard',
  id: 3,
  status: 'Closed',
  tag: ['eng'],
  owner: 'Carrie'
}, {
  type: 'Watch',
  id: 4,
  status: 'Open',
  tag: ['sales', 'ga'],
  owner: 'Dewey'
}, {
  type: 'Dashboard',
  id: 5,
  status: 'Closed',
  tag: ['finance'],
  owner: 'Carrie'
}];
export var SearchBar = function SearchBar() {
  var _useState = useState(''),
    _useState2 = _slicedToArray(_useState, 2),
    query = _useState2[0],
    setQuery = _useState2[1];
  var renderSearch = function renderSearch() {
    var filters = [{
      type: 'field_value_toggle_group',
      field: 'status',
      items: [{
        value: 'open',
        name: 'Open'
      }, {
        value: 'closed',
        name: 'Closed'
      }]
    }, {
      type: 'field_value_selection',
      field: 'tag',
      name: 'Tag',
      multiSelect: 'or',
      options: tagsMap
    }];
    var schema = {
      strict: true,
      fields: {
        type: {
          type: 'string'
        },
        status: {
          type: 'string'
        },
        created: {
          type: 'date'
        },
        owner: {
          type: 'string'
        },
        tag: {
          type: 'string'
        }
      }
    };
    return ___EmotionJSX(EuiSearchBar, {
      query: query,
      box: {
        placeholder: 'type:visualization',
        schema: schema
      },
      filters: filters,
      onChange: function onChange(_ref) {
        var query = _ref.query;
        if (query) setQuery(query);
      }
    });
  };
  var renderTable = function renderTable() {
    var columns = [{
      name: 'Type',
      field: 'type'
    }, {
      name: 'Owner',
      field: 'owner'
    }, {
      name: 'Open',
      field: 'status'
    }, {
      name: 'Tags',
      field: 'tag'
    }];
    var queriedItems = EuiSearchBar.Query.execute(query, items, {
      defaultFields: ['owner', 'tag', 'type']
    });
    return ___EmotionJSX(EuiBasicTable, {
      items: queriedItems,
      columns: columns
    });
  };
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiFlexGroup, {
    alignItems: "center"
  }, ___EmotionJSX(EuiFlexItem, null, renderSearch())), ___EmotionJSX(EuiSpacer, {
    size: "l"
  }), ___EmotionJSX(EuiFlexGroup, null, ___EmotionJSX(EuiFlexItem, {
    grow: 6
  }, renderTable())));
};
describe('EuiSearchBar', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(SearchBar, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after a full-text search', function () {
      cy.get('input[type="search"]').focus();
      cy.get('input[type="search"]').type('watch');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 1);
      cy.checkAxe();
      cy.realPress('Tab');
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering on Open items', function () {
      cy.get('button.euiButtonEmpty').first().focus();
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering by Tags', function () {
      cy.get('button.euiButtonEmpty').last().focus();
      cy.realPress('Enter');
      cy.realPress('ArrowDown');
      cy.realPress('Enter');
      cy.realPress('Escape');
      cy.get('button.euiButtonEmpty').last().should('have.focus');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.repeatRealPress(['Shift', 'Tab'], 3);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
});