import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _typeof from "@babel/runtime/helpers/typeof";
var _excluded = ["schema"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { RenderWithEuiTheme, htmlIdGenerator } from '../../services';
import { isString } from '../../services/predicate';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiSearchBox } from './search_box';
import { EuiSearchBarFilters } from './search_filters';
import { Query } from './query';
import { euiSearchBar__searchHolder, euiSearchBar__filtersHolder } from './search_bar.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export { Query, AST as Ast } from './query';
var parseQuery = function parseQuery(query, props) {
  var _props$box, _props$box2;
  var schema = undefined;
  if ((_props$box = props.box) !== null && _props$box !== void 0 && _props$box.schema && _typeof((_props$box2 = props.box) === null || _props$box2 === void 0 ? void 0 : _props$box2.schema) === 'object') {
    schema = props.box.schema;
  }
  var dateFormat = props.dateFormat;
  var parseOptions = {
    schema: schema,
    dateFormat: dateFormat
  };
  if (!query) {
    return Query.parse('', parseOptions);
  }
  return isString(query) ? Query.parse(query, parseOptions) : query;
};
export var EuiSearchBar = /*#__PURE__*/function (_Component) {
  function EuiSearchBar(props) {
    var _this;
    _classCallCheck(this, EuiSearchBar);
    _this = _callSuper(this, EuiSearchBar, [props]);
    _defineProperty(_this, "hintId", htmlIdGenerator('__hint')());
    _defineProperty(_this, "onSearch", function (queryText) {
      try {
        var query = parseQuery(queryText, _this.props);
        _this.notifyControllingParent({
          query: query,
          queryText: queryText,
          error: null
        });
        _this.setState({
          query: query,
          queryText: queryText,
          error: null
        });
      } catch (e) {
        var error = e instanceof Error ? {
          name: e.name,
          message: e.message
        } : {
          name: 'Unexpected error',
          message: String(e)
        };
        _this.notifyControllingParent({
          query: null,
          queryText: queryText,
          error: error
        });
        _this.setState({
          queryText: queryText,
          error: error
        });
      }
    });
    _defineProperty(_this, "onFiltersChange", function (query) {
      _this.notifyControllingParent({
        query: query,
        queryText: query.text,
        error: null
      });
      _this.setState({
        query: query,
        queryText: query.text,
        error: null
      });
    });
    var _query = parseQuery(props.defaultQuery || props.query, props);
    _this.state = {
      query: _query,
      queryText: _query.text,
      error: null,
      isHintVisible: false
    };
    return _this;
  }
  _inherits(EuiSearchBar, _Component);
  return _createClass(EuiSearchBar, [{
    key: "notifyControllingParent",
    value: function notifyControllingParent(newState) {
      var onChange = this.props.onChange;
      if (!onChange) {
        return;
      }
      var oldState = this.state;
      var query = newState.query,
        queryText = newState.queryText,
        error = newState.error;
      var isQueryDifferent = oldState.queryText !== queryText;
      var oldError = oldState.error ? oldState.error.message : null;
      var newError = error ? error.message : null;
      var isErrorDifferent = oldError !== newError;
      if (isQueryDifferent || isErrorDifferent) {
        if (error == null) {
          onChange({
            query: query,
            queryText: queryText,
            error: error
          });
        } else {
          onChange({
            query: null,
            queryText: queryText,
            error: error
          });
        }
      }
    }
  }, {
    key: "renderTools",
    value: function renderTools(tools) {
      if (!tools) {
        return undefined;
      }
      if (Array.isArray(tools)) {
        return tools.map(function (tool) {
          return ___EmotionJSX(EuiFlexItem, {
            grow: false,
            key: tool.key == null ? undefined : tool.key
          }, tool);
        });
      }
      return ___EmotionJSX(EuiFlexItem, {
        grow: false
      }, tools);
    }
  }, {
    key: "render",
    value: function render() {
      var _hint$popoverProps$is,
        _hint$popoverProps,
        _this2 = this;
      var _this$state = this.state,
        query = _this$state.query,
        queryText = _this$state.queryText,
        error = _this$state.error,
        isHintVisibleState = _this$state.isHintVisible;
      var _this$props = this.props,
        _this$props$box = _this$props.box,
        _this$props$box2 = _this$props$box === void 0 ? {
          schema: ''
        } : _this$props$box,
        schema = _this$props$box2.schema,
        box = _objectWithoutProperties(_this$props$box2, _excluded),
        filters = _this$props.filters,
        toolsLeft = _this$props.toolsLeft,
        toolsRight = _this$props.toolsRight,
        hint = _this$props.hint;
      var toolsLeftEl = this.renderTools(toolsLeft);
      var toolsRightEl = this.renderTools(toolsRight);
      var isHintVisible = (_hint$popoverProps$is = hint === null || hint === void 0 || (_hint$popoverProps = hint.popoverProps) === null || _hint$popoverProps === void 0 ? void 0 : _hint$popoverProps.isOpen) !== null && _hint$popoverProps$is !== void 0 ? _hint$popoverProps$is : isHintVisibleState;
      return ___EmotionJSX(RenderWithEuiTheme, null, function (euiTheme) {
        return ___EmotionJSX(EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          wrap: true
        }, toolsLeftEl, ___EmotionJSX(EuiFlexItem, {
          className: "euiSearchBar__searchHolder",
          css: euiSearchBar__searchHolder(euiTheme),
          grow: true
        }, ___EmotionJSX(EuiSearchBox, _extends({}, box, {
          query: queryText,
          onSearch: _this2.onSearch,
          isInvalid: error != null,
          title: error ? error.message : undefined,
          "aria-describedby": isHintVisible ? "".concat(_this2.hintId) : undefined,
          hint: hint ? _objectSpread({
            isVisible: isHintVisible,
            setIsVisible: function setIsVisible(isVisible) {
              _this2.setState({
                isHintVisible: isVisible
              });
            },
            id: _this2.hintId
          }, hint) : undefined
        }))), filters && ___EmotionJSX(EuiFlexItem, {
          className: "euiSearchBar__filtersHolder",
          css: euiSearchBar__filtersHolder(euiTheme),
          grow: false
        }, ___EmotionJSX(EuiSearchBarFilters, {
          filters: filters,
          query: query,
          onChange: _this2.onFiltersChange
        })), toolsRightEl);
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if ((nextProps.query || nextProps.query === '') && (!prevState.query || typeof nextProps.query !== 'string' && nextProps.query.text !== prevState.query.text || typeof nextProps.query === 'string' && nextProps.query !== prevState.query.text)) {
        var query = parseQuery(nextProps.query, nextProps);
        return {
          query: query,
          queryText: query.text,
          error: null,
          isHintVisible: prevState.isHintVisible
        };
      }
      return null;
    }
  }]);
}(Component);
_defineProperty(EuiSearchBar, "Query", Query);