import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["query", "placeholder", "incremental", "hint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useRef, useLayoutEffect } from 'react';
import { useEuiI18n } from '../i18n';
import { EuiFieldSearch } from '../form';
import { EuiInputPopover } from '../popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSearchBox = function EuiSearchBox(_ref) {
  var query = _ref.query,
    placeholder = _ref.placeholder,
    incremental = _ref.incremental,
    hint = _ref.hint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _inputRef = useRef(null);
  useLayoutEffect(function () {
    if (_inputRef.current) {
      _inputRef.current.value = query;
      _inputRef.current.dispatchEvent(new Event('change'));
    }
  }, [query]);
  var defaultPlaceholder = useEuiI18n('euiSearchBox.placeholder', 'Search...');
  var ariaLabelIncremental = useEuiI18n('euiSearchBox.incrementalAriaLabel', 'This is a search bar. As you type, the results lower in the page will automatically filter.');
  var ariaLabelEnter = useEuiI18n('euiSearchBox.ariaLabel', 'This is a search bar. After typing your query, hit enter to filter the results lower in the page.');
  var search = ___EmotionJSX(EuiFieldSearch, _extends({
    inputRef: function inputRef(input) {
      return _inputRef.current = input;
    },
    fullWidth: true,
    defaultValue: query,
    incremental: incremental,
    "aria-label": incremental ? ariaLabelIncremental : ariaLabelEnter,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    onFocus: function onFocus() {
      hint === null || hint === void 0 || hint.setIsVisible(true);
    }
  }, rest));
  if (hint) {
    return ___EmotionJSX(EuiInputPopover, _extends({
      disableFocusTrap: true,
      input: search,
      isOpen: hint.isVisible,
      fullWidth: true,
      closePopover: function closePopover() {
        hint.setIsVisible(false);
      },
      panelProps: {
        'aria-live': undefined,
        'aria-modal': undefined,
        role: undefined,
        tabIndex: -1,
        id: hint.id
      }
    }, hint.popoverProps), hint.content);
  }
  return search;
};