import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButton } from '../button';
import { EuiPopover } from '../popover';
import { EuiSelectable } from './selectable';
import { jsx as ___EmotionJSX } from "@emotion/react";
var options = [{
  label: 'Titan',
  'data-test-subj': 'titanOption'
}, {
  label: 'Enceladus'
}, {
  label: "Pandora is one of Saturn's moons, named for a Titaness of Greek mythology"
}];
var excludedOptions = [{
  label: 'Titan',
  'data-test-subj': 'titanOption',
  checked: 'on'
}, {
  label: 'Enceladus',
  checked: 'off'
}, {
  label: "Pandora is one of Saturn's moons, named for a Titaness of Greek mythology",
  checked: 'mixed'
}];
describe('EuiSelectable', function () {
  describe('with a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount(___EmotionJSX(EuiSelectable, {
        options: options,
        onChange: onChange,
        searchable: true
      }, function (list, search) {
        return ___EmotionJSX(React.Fragment, null, search, list);
      }));
      cy.checkAxe();
    });
  });
  describe('without a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount(___EmotionJSX(EuiSelectable, {
        "aria-label": "No search box",
        options: options,
        onChange: onChange
      }, function (list) {
        return ___EmotionJSX(React.Fragment, null, list);
      }));
      cy.checkAxe();
    });
  });
  describe('with excluded and mixed options configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount(___EmotionJSX(EuiSelectable, {
        "aria-label": "Excluded and mixed options",
        options: excludedOptions,
        onChange: onChange
      }, function (list) {
        return ___EmotionJSX(React.Fragment, null, list);
      }));
      cy.checkAxe();
    });
  });
  describe('nested in `EuiPopover` component', function () {
    var EuiSelectableNested = function EuiSelectableNested() {
      var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        isPopoverOpen = _useState2[0],
        setIsPopoverOpen = _useState2[1];
      var onChange = function onChange() {};
      var onClosePopover = function onClosePopover() {};
      var onButtonClick = function onButtonClick() {
        setIsPopoverOpen(!isPopoverOpen);
      };
      var button = ___EmotionJSX(EuiButton, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: onButtonClick
      }, "Show popover");
      return ___EmotionJSX(EuiPopover, {
        id: "data-cy-popover-1",
        panelPaddingSize: "s",
        button: button,
        isOpen: isPopoverOpen,
        closePopover: onClosePopover
      }, ___EmotionJSX(EuiSelectable, {
        "aria-label": "With popover",
        options: options,
        onChange: onChange,
        searchable: true
      }, function (list, search) {
        return ___EmotionJSX(React.Fragment, null, search, list);
      }));
    };
    it('has no accessibility errors', function () {
      cy.realMount(___EmotionJSX(EuiSelectableNested, null));
      cy.get('button').realClick();
      cy.get('li[role=option]').first(); // Make sure the EuiSelectable is rendered before a11y check
      cy.checkAxe();
    });
  });
});