import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "options", "onChange", "onActiveOptionChange", "searchable", "searchProps", "singleSelection", "isLoading", "listProps", "renderOption", "height", "allowExclusions", "aria-label", "aria-describedby", "loadingMessage", "noMatchesMessage", "emptyMessage", "errorMessage", "selectableScreenReaderText", "isPreFiltered", "optionMatcher"],
  _excluded2 = ["aria-label", "aria-describedby", "onChange", "defaultValue", "inputRef"],
  _excluded3 = ["aria-label", "aria-describedby", "isVirtualized", "rowHeight"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import classNames from 'classnames';
import { keys, htmlIdGenerator } from '../../services';
import { EuiLoadingSpinner } from '../loading';
import { EuiSpacer } from '../spacer';
import { EuiScreenReaderLive, EuiScreenReaderOnly } from '../accessibility';
import { EuiI18n } from '../i18n';
import { EuiSelectableSearch } from './selectable_search';
import { EuiSelectableMessage } from './selectable_message';
import { EuiSelectableList } from './selectable_list';
import { createPartialStringEqualityOptionMatcher, getMatchingOptions } from './matching_options';
import { euiSelectableStyles as styles } from './selectable.styles';

// The `searchable` prop has significant implications for a11y.
// When present, we effectively change from adhering
// to the ARIA `listbox` spec (https://www.w3.org/TR/wai-aria-practices-1.2/#Listbox)
// to the ARIA `combobox` spec (https://www.w3.org/TR/wai-aria-practices-1.2/#combobox)
// and (re)implement all relevant attributes and keyboard interactions.
// Take note of logic that relies on `searchable` to ensure that any
// modifications remain in alignment.
//
// `searchProps` can only be specified when `searchable` is true
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectable = /*#__PURE__*/function (_Component) {
  function EuiSelectable(props) {
    var _searchProps$onChange;
    var _this;
    _classCallCheck(this, EuiSelectable);
    _this = _callSuper(this, EuiSelectable, [props]);
    _defineProperty(_this, "inputRef", null);
    _defineProperty(_this, "containerRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "optionsListRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "preventOnFocus", false);
    _defineProperty(_this, "rootId", void 0);
    _defineProperty(_this, "messageContentId", void 0);
    _defineProperty(_this, "listId", void 0);
    _defineProperty(_this, "isFocusOnSearchOrListBox", function (target) {
      var _this$optionsListRef$;
      var searchHasFocus = _this.props.searchable && target === _this.inputRef;
      var listBox = (_this$optionsListRef$ = _this.optionsListRef.current) === null || _this$optionsListRef$ === void 0 || (_this$optionsListRef$ = _this$optionsListRef$.listBoxRef) === null || _this$optionsListRef$ === void 0 ? void 0 : _this$optionsListRef$.parentElement;
      var listBoxContainsFocus = target instanceof Node && (listBox === null || listBox === void 0 ? void 0 : listBox.contains(target));
      var listBoxHasFocus = target === listBox || listBoxContainsFocus;
      return searchHasFocus || listBoxHasFocus;
    });
    _defineProperty(_this, "onMouseDown", function () {
      // Bypass onFocus when a click event originates from this.containerRef.
      // Prevents onFocus from scrolling away from a clicked option and negating the selection event.
      // https://github.com/elastic/eui/issues/4147
      _this.preventOnFocus = true;
    });
    _defineProperty(_this, "onFocus", function (event) {
      if (_this.preventOnFocus) {
        _this.preventOnFocus = false;
        return;
      }
      if (!_this.state.visibleOptions.length || _this.state.activeOptionIndex != null) {
        return;
      }
      if (event && !_this.isFocusOnSearchOrListBox(event.target)) {
        return;
      }
      var firstSelected = _this.state.visibleOptions.findIndex(function (option) {
        return option.checked && !option.disabled && !option.isGroupLabel;
      });
      if (firstSelected > -1) {
        _this.setState({
          activeOptionIndex: firstSelected,
          isFocused: true
        });
      } else {
        _this.setState({
          activeOptionIndex: _this.state.visibleOptions.findIndex(function (option) {
            return !option.disabled && !option.isGroupLabel;
          }),
          isFocused: true
        });
      }
    });
    _defineProperty(_this, "onKeyDown", function (event) {
      var optionsList = _this.optionsListRef.current;

      // Check if the user is interacting with something other than the
      // searchbox or selection list. If so, the user may be attempting to
      // interact with the search clear button or a totally custom button,
      // and listbox keyboard navigation/selection should not be triggered.
      if (!_this.isFocusOnSearchOrListBox(event.target)) {
        _this.setState({
          activeOptionIndex: undefined,
          isFocused: false
        });
        return;
      }
      switch (event.key) {
        case keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          _this.incrementActiveOptionIndex(-1);
          break;
        case keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          _this.incrementActiveOptionIndex(1);
          break;

        // For non-searchable instances, SPACE interaction should align with
        // the user expectation of selection toggling (e.g., input[type=checkbox]).
        // ENTER is also a valid selection mechanism in this case.
        case keys.ENTER:
        case keys.SPACE:
          if (_this.props.searchable) {
            // For searchable instances, SPACE is reserved as a character for filtering
            // via the input box, and as such only ENTER will toggle selection.
            if (event.target === _this.inputRef && event.key === keys.SPACE) {
              return;
            }
          }
          event.preventDefault();
          event.stopPropagation();
          if (_this.state.activeOptionIndex != null && optionsList) {
            event.persist(); // NOTE: This is needed for React v16 backwards compatibility
            optionsList.onAddOrRemoveOption(_this.state.visibleOptions[_this.state.activeOptionIndex], event);
          }
          break;
        case keys.ALT:
        case keys.SHIFT:
        case keys.CTRL:
        case keys.META:
          break;
        default:
          _this.setState({
            activeOptionIndex: undefined
          }, _this.onFocus);
          break;
      }
    });
    _defineProperty(_this, "incrementActiveOptionIndex", function (amount) {
      // If there are no options available, do nothing.
      if (!_this.state.visibleOptions.length) {
        return;
      }
      _this.setState(function (_ref) {
        var activeOptionIndex = _ref.activeOptionIndex,
          visibleOptions = _ref.visibleOptions;
        var nextActiveOptionIndex;
        if (activeOptionIndex == null) {
          // If this is the beginning of the user's keyboard navigation of the menu, then we'll focus
          // either the first or last item.
          nextActiveOptionIndex = amount < 0 ? visibleOptions.length - 1 : 0;
        } else {
          nextActiveOptionIndex = activeOptionIndex + amount;
          if (nextActiveOptionIndex < 0) {
            nextActiveOptionIndex = visibleOptions.length - 1;
          } else if (nextActiveOptionIndex === visibleOptions.length) {
            nextActiveOptionIndex = 0;
          }
        }

        // Group titles and disabled options are included in option list but are not selectable
        var direction = amount > 0 ? 1 : -1;
        while (visibleOptions[nextActiveOptionIndex].isGroupLabel || visibleOptions[nextActiveOptionIndex].disabled) {
          nextActiveOptionIndex = nextActiveOptionIndex + direction;
          if (nextActiveOptionIndex < 0) {
            nextActiveOptionIndex = visibleOptions.length - 1;
          } else if (nextActiveOptionIndex === visibleOptions.length) {
            nextActiveOptionIndex = 0;
          }
        }
        return {
          activeOptionIndex: nextActiveOptionIndex
        };
      });
    });
    _defineProperty(_this, "onSearchChange", function (searchValue, visibleOptions) {
      var _this$props$searchPro, _this$props$searchPro2;
      _this.setState({
        searchValue: searchValue,
        visibleOptions: visibleOptions,
        activeOptionIndex: undefined
      }, function () {
        if (_this.state.isFocused) {
          _this.onFocus();
        }
      });
      (_this$props$searchPro = _this.props.searchProps) === null || _this$props$searchPro === void 0 || (_this$props$searchPro2 = _this$props$searchPro.onChange) === null || _this$props$searchPro2 === void 0 || _this$props$searchPro2.call(_this$props$searchPro, searchValue, visibleOptions);
    });
    _defineProperty(_this, "onContainerBlur", function (e) {
      // Ignore blur events when moving from search to option to avoid activeOptionIndex conflicts
      if (_this.isFocusOnSearchOrListBox(e.relatedTarget)) {
        return;
      }
      _this.setState({
        activeOptionIndex: undefined,
        isFocused: false
      });
    });
    _defineProperty(_this, "onOptionClick", function (options, event, clickedOption) {
      var _this$props = _this.props,
        isPreFiltered = _this$props.isPreFiltered,
        onChange = _this$props.onChange,
        optionMatcher = _this$props.optionMatcher;
      var searchValue = _this.state.searchValue;
      var visibleOptions = getMatchingOptions({
        options: options,
        searchValue: searchValue !== null && searchValue !== void 0 ? searchValue : '',
        isPreFiltered: !!isPreFiltered,
        selectedOptions: [],
        optionMatcher: optionMatcher
      });
      _this.setState({
        visibleOptions: visibleOptions
      });
      if (onChange) {
        onChange(options, event, clickedOption);
      }
    });
    _defineProperty(_this, "scrollToItem", function (index, align) {
      var _this$optionsListRef$2;
      (_this$optionsListRef$2 = _this.optionsListRef.current) === null || _this$optionsListRef$2 === void 0 || (_this$optionsListRef$2 = _this$optionsListRef$2.listRef) === null || _this$optionsListRef$2 === void 0 || _this$optionsListRef$2.scrollToItem(index, align);
    });
    _defineProperty(_this, "makeOptionId", function (index) {
      return index != null ? "".concat(_this.listId, "_option-").concat(index) : '';
    });
    _this.rootId = props.id ? function (suffix) {
      return "".concat(props.id).concat(suffix ? "_".concat(suffix) : '');
    } : htmlIdGenerator();
    _this.listId = _this.rootId('listbox');
    _this.messageContentId = _this.rootId('messageContent');
    var _options = props.options,
      singleSelection = props.singleSelection,
      _isPreFiltered = props.isPreFiltered,
      searchProps = props.searchProps;
    var initialSearchValue = (searchProps === null || searchProps === void 0 ? void 0 : searchProps.value) || String((searchProps === null || searchProps === void 0 ? void 0 : searchProps.defaultValue) || '');
    var _visibleOptions = getMatchingOptions({
      options: _options,
      searchValue: initialSearchValue,
      isPreFiltered: !!_isPreFiltered,
      selectedOptions: [],
      optionMatcher: props.optionMatcher
    });
    searchProps === null || searchProps === void 0 || (_searchProps$onChange = searchProps.onChange) === null || _searchProps$onChange === void 0 || _searchProps$onChange.call(searchProps, initialSearchValue, _visibleOptions);

    // ensure that the currently selected single option is active if it is in the visibleOptions
    var selectedOptions = _options.filter(function (option) {
      return option.checked;
    });
    var _activeOptionIndex;
    if (singleSelection && selectedOptions.length === 1) {
      if (_visibleOptions.includes(selectedOptions[0])) {
        _activeOptionIndex = _visibleOptions.indexOf(selectedOptions[0]);
      }
    }
    _this.state = {
      activeOptionIndex: _activeOptionIndex,
      searchValue: initialSearchValue,
      visibleOptions: _visibleOptions,
      isFocused: false
    };
    return _this;
  }
  _inherits(EuiSelectable, _Component);
  return _createClass(EuiSelectable, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.activeOptionIndex !== this.state.activeOptionIndex) {
        var _this$props$onActiveO, _this$props2;
        var activeOption = this.state.activeOptionIndex != null ? this.state.visibleOptions[this.state.activeOptionIndex] : null;
        (_this$props$onActiveO = (_this$props2 = this.props).onActiveOptionChange) === null || _this$props$onActiveO === void 0 || _this$props$onActiveO.call(_this$props2, activeOption);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props3 = this.props,
        children = _this$props3.children,
        className = _this$props3.className,
        options = _this$props3.options,
        onChange = _this$props3.onChange,
        onActiveOptionChange = _this$props3.onActiveOptionChange,
        searchable = _this$props3.searchable,
        searchProps = _this$props3.searchProps,
        singleSelection = _this$props3.singleSelection,
        isLoading = _this$props3.isLoading,
        listProps = _this$props3.listProps,
        renderOption = _this$props3.renderOption,
        height = _this$props3.height,
        allowExclusions = _this$props3.allowExclusions,
        ariaLabel = _this$props3['aria-label'],
        ariaDescribedby = _this$props3['aria-describedby'],
        loadingMessage = _this$props3.loadingMessage,
        noMatchesMessage = _this$props3.noMatchesMessage,
        emptyMessage = _this$props3.emptyMessage,
        errorMessage = _this$props3.errorMessage,
        selectableScreenReaderText = _this$props3.selectableScreenReaderText,
        isPreFiltered = _this$props3.isPreFiltered,
        optionMatcher = _this$props3.optionMatcher,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var _this$state = this.state,
        searchValue = _this$state.searchValue,
        visibleOptions = _this$state.visibleOptions,
        activeOptionIndex = _this$state.activeOptionIndex;

      // Some messy destructuring here to remove aria-label/describedby from searchProps and listProps
      // Made messier by some TS requirements
      // The aria attributes are then used in getAccessibleName() to place them where they need to go
      var unknownAccessibleName = {
        'aria-label': undefined,
        'aria-describedby': undefined
      };
      var _ref2 = searchProps || unknownAccessibleName,
        searchAriaLabel = _ref2['aria-label'],
        searchAriaDescribedby = _ref2['aria-describedby'],
        propsOnChange = _ref2.onChange,
        defaultValue = _ref2.defaultValue,
        inputRef = _ref2.inputRef,
        cleanedSearchProps = _objectWithoutProperties(_ref2, _excluded2);
      var _ref3 = listProps || unknownAccessibleName,
        listAriaLabel = _ref3['aria-label'],
        listAriaDescribedby = _ref3['aria-describedby'],
        isVirtualized = _ref3.isVirtualized,
        rowHeight = _ref3.rowHeight,
        cleanedListProps = _objectWithoutProperties(_ref3, _excluded3);
      var virtualizedProps;
      if (isVirtualized === false) {
        virtualizedProps = {
          isVirtualized: isVirtualized
        };
      } else if (rowHeight != null) {
        virtualizedProps = {
          rowHeight: rowHeight
        };
      }
      var classes = classNames('euiSelectable', className);
      var cssStyles = [styles.euiSelectable, height === 'full' && styles.fullHeight];

      /** Create message content that replaces the list if no options are available (yet) */
      var messageContent;
      if (errorMessage != null) {
        messageContent = typeof errorMessage === 'string' ? ___EmotionJSX("p", null, errorMessage) : errorMessage;
      } else if (isLoading) {
        if (loadingMessage === undefined || typeof loadingMessage === 'string') {
          messageContent = ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiLoadingSpinner, {
            size: "m"
          }), ___EmotionJSX(EuiSpacer, {
            size: "xs"
          }), ___EmotionJSX("p", null, loadingMessage || ___EmotionJSX(EuiI18n, {
            token: "euiSelectable.loadingOptions",
            default: "Loading options"
          })));
        } else {
          messageContent = /*#__PURE__*/React.cloneElement(loadingMessage, _objectSpread({
            id: this.messageContentId
          }, loadingMessage.props));
        }
      } else if (searchValue && visibleOptions.length === 0) {
        if (noMatchesMessage === undefined || typeof noMatchesMessage === 'string') {
          messageContent = ___EmotionJSX("p", null, noMatchesMessage || ___EmotionJSX(EuiI18n, {
            token: "euiSelectable.noMatchingOptions",
            default: "{searchValue} doesn't match any options",
            values: {
              searchValue: ___EmotionJSX("strong", null, searchValue)
            }
          }));
        } else {
          messageContent = /*#__PURE__*/React.cloneElement(noMatchesMessage, _objectSpread({
            id: this.messageContentId
          }, noMatchesMessage.props));
        }
      } else if (!options.length) {
        if (emptyMessage === undefined || typeof emptyMessage === 'string') {
          messageContent = ___EmotionJSX("p", null, emptyMessage || ___EmotionJSX(EuiI18n, {
            token: "euiSelectable.noAvailableOptions",
            default: "No options available"
          }));
        } else {
          messageContent = /*#__PURE__*/React.cloneElement(emptyMessage, _objectSpread({
            id: this.messageContentId
          }, emptyMessage.props));
        }
      }

      /**
       * There are lots of ways to add an accessible name
       * Usually we want the same name for the input and the listbox (which is added by aria-label/describedby)
       * But you can always override it using searchProps or listProps
       * This finds the correct name to use
       *
       * TODO: This doesn't handle being labelled (<label for="idOfInput">)
       */
      var getAccessibleName = function getAccessibleName(props, messageContentId) {
        if (props && props['aria-label']) {
          return {
            'aria-label': props['aria-label']
          };
        }
        var messageContentIdString = messageContentId ? " ".concat(messageContentId) : '';
        if (props && props['aria-describedby']) {
          return {
            'aria-describedby': "".concat(props['aria-describedby']).concat(messageContentIdString)
          };
        }
        if (ariaLabel) {
          return {
            'aria-label': ariaLabel
          };
        }
        if (ariaDescribedby) {
          return {
            'aria-describedby': "".concat(ariaDescribedby).concat(messageContentIdString)
          };
        }
        return {};
      };
      var searchAccessibleName = getAccessibleName(searchProps, this.messageContentId);
      var searchHasAccessibleName = Boolean(Object.keys(searchAccessibleName).length);
      var search = searchable ? ___EmotionJSX(EuiI18n, {
        tokens: ['euiSelectable.screenReaderInstructions', 'euiSelectable.placeholderName'],
        defaults: ['Use the Up and Down arrow keys to move focus over options. Press Enter to select. Press Escape to collapse options.', 'Filter options']
      }, function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 2),
          screenReaderInstructions = _ref5[0],
          placeholderName = _ref5[1];
        return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSelectableSearch, _extends({
          "aria-describedby": listAriaDescribedbyId,
          key: "listSearch",
          options: options,
          value: searchValue,
          onChange: _this2.onSearchChange,
          listId: _this2.optionsListRef.current ? _this2.listId : undefined // Only pass the listId if it exists on the page
          ,
          "aria-activedescendant": _this2.makeOptionId(activeOptionIndex) // the current faux-focused option
          ,
          placeholder: placeholderName,
          isPreFiltered: !!isPreFiltered,
          optionMatcher: optionMatcher,
          inputRef: function inputRef(node) {
            var _searchProps$inputRef;
            _this2.inputRef = node;
            searchProps === null || searchProps === void 0 || (_searchProps$inputRef = searchProps.inputRef) === null || _searchProps$inputRef === void 0 || _searchProps$inputRef.call(searchProps, node);
          }
        }, searchHasAccessibleName ? searchAccessibleName : {
          'aria-label': placeholderName
        }, cleanedSearchProps)), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
          id: listAriaDescribedbyId
        }, selectableScreenReaderText, " ", screenReaderInstructions)));
      }) : undefined;
      var resultsLength = visibleOptions.filter(function (option) {
        return !option.disabled;
      }).length;
      var listScreenReaderStatus = searchable && ___EmotionJSX(EuiI18n, {
        token: "euiSelectable.searchResults",
        default: function _default(_ref6) {
          var resultsLength = _ref6.resultsLength;
          return "".concat(resultsLength, " result").concat(resultsLength === 1 ? '' : 's', " available");
        },
        values: {
          resultsLength: resultsLength
        }
      });
      var listAriaDescribedbyId = this.rootId('instructions');
      var listAccessibleName = getAccessibleName(listProps, listAriaDescribedbyId);
      var listHasAccessibleName = Boolean(Object.keys(listAccessibleName).length);
      var list = ___EmotionJSX(EuiI18n, {
        token: "euiSelectable.placeholderName",
        default: "Filter options"
      }, function (placeholderName) {
        return ___EmotionJSX(React.Fragment, null, searchable && ___EmotionJSX(EuiScreenReaderLive, {
          isActive: messageContent != null || activeOptionIndex != null
        }, messageContent || listScreenReaderStatus), messageContent ? ___EmotionJSX(EuiSelectableMessage, {
          "data-test-subj": "euiSelectableMessage",
          id: _this2.messageContentId,
          bordered: listProps && listProps.bordered
        }, messageContent) : ___EmotionJSX(EuiSelectableList, _extends({
          "data-test-subj": "euiSelectableList",
          key: "list",
          options: options,
          visibleOptions: visibleOptions,
          searchValue: searchValue,
          isPreFiltered: isPreFiltered,
          activeOptionIndex: activeOptionIndex,
          setActiveOptionIndex: function setActiveOptionIndex(index, cb) {
            _this2.setState({
              activeOptionIndex: index
            }, cb);
          },
          onOptionClick: _this2.onOptionClick,
          singleSelection: singleSelection,
          ref: _this2.optionsListRef,
          renderOption: renderOption,
          height: height,
          allowExclusions: allowExclusions,
          searchable: searchable,
          makeOptionId: _this2.makeOptionId,
          listId: _this2.listId
        }, listHasAccessibleName ? listAccessibleName : searchable && {
          'aria-label': placeholderName
        }, cleanedListProps, virtualizedProps)));
      });
      return ___EmotionJSX("div", _extends({
        ref: this.containerRef,
        css: cssStyles,
        className: classes,
        onKeyDown: this.onKeyDown,
        onBlur: this.onContainerBlur,
        onFocus: this.onFocus,
        onMouseDown: this.onMouseDown
      }, rest), children && children(list, search));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var _stateUpdate$searchVa;
      var options = nextProps.options,
        isPreFiltered = nextProps.isPreFiltered,
        searchProps = nextProps.searchProps,
        optionMatcher = nextProps.optionMatcher;
      var activeOptionIndex = prevState.activeOptionIndex,
        searchValue = prevState.searchValue;
      var stateUpdate = {
        searchValue: searchValue,
        activeOptionIndex: activeOptionIndex
      };
      if ((searchProps === null || searchProps === void 0 ? void 0 : searchProps.value) != null && searchProps.value !== searchValue) {
        stateUpdate.searchValue = searchProps.value;
      }
      stateUpdate.visibleOptions = getMatchingOptions({
        options: options,
        searchValue: (_stateUpdate$searchVa = stateUpdate.searchValue) !== null && _stateUpdate$searchVa !== void 0 ? _stateUpdate$searchVa : '',
        isPreFiltered: !!isPreFiltered,
        selectedOptions: [],
        optionMatcher: optionMatcher
      });
      if (activeOptionIndex != null && activeOptionIndex >= stateUpdate.visibleOptions.length) {
        stateUpdate.activeOptionIndex = -1;
      }
      return stateUpdate;
    }
  }]);
}(Component);
_defineProperty(EuiSelectable, "defaultProps", {
  options: [],
  singleSelection: false,
  searchable: false,
  isPreFiltered: false,
  optionMatcher: createPartialStringEqualityOptionMatcher()
});