import _typeof from "@babel/runtime/helpers/typeof";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["data"],
  _excluded2 = ["label", "isGroupLabel", "checked", "disabled", "prepend", "append", "ref", "key", "searchableLabel", "data", "truncationProps"],
  _excluded3 = ["className", "options", "searchValue", "onOptionClick", "renderOption", "height", "windowProps", "rowHeight", "activeOptionIndex", "makeOptionId", "showIcons", "singleSelection", "visibleOptions", "allowExclusions", "bordered", "paddingSize", "searchable", "onFocusBadge", "listId", "setActiveOptionIndex", "aria-label", "aria-labelledby", "aria-describedby", "role", "isPreFiltered", "isVirtualized", "textWrap", "truncationProps", "autoFocus"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, memo } from 'react';
import classNames from 'classnames';
import { FixedSizeList, areEqual } from 'react-window';
import { RenderWithEuiStylesMemoizer } from '../../../services';
import { EuiAutoSizer } from '../../auto_sizer';
import { EuiHighlight } from '../../highlight';
import { EuiMark } from '../../mark';
import { EuiTextTruncate } from '../../text_truncate';
import { EuiSelectableListItem } from './selectable_list_item';
import { euiSelectableListStyles } from './selectable_list.styles';

// Consumer Configurable Props via `EuiSelectable.listProps`
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectableList = /*#__PURE__*/function (_Component) {
  function EuiSelectableList(props) {
    var _this;
    _classCallCheck(this, EuiSelectableList);
    _this = _callSuper(this, EuiSelectableList, [props]);
    _defineProperty(_this, "animationFrameId", void 0);
    // counter for tracking list renders and ensuring rerenders
    _defineProperty(_this, "listRowRerender", 0);
    _defineProperty(_this, "listRef", null);
    _defineProperty(_this, "listBoxRef", null);
    _defineProperty(_this, "setListRef", function (ref) {
      _this.listRef = ref;
      if (ref && _this.props.activeOptionIndex) {
        ref.scrollToItem(_this.props.activeOptionIndex, 'auto');
      }
    });
    _defineProperty(_this, "removeScrollableTabStop", function (ref) {
      // Firefox adds a tab stop for scrollable containers
      // We handle this inside so need to stop firefox from doing its thing
      if (ref) {
        ref.setAttribute('tabindex', '-1');
      }
    });
    _defineProperty(_this, "setListBoxRef", function (ref) {
      _this.listBoxRef = ref;
      var _this$props = _this.props,
        listId = _this$props.listId,
        searchable = _this$props.searchable,
        singleSelection = _this$props.singleSelection,
        autoFocus = _this$props.autoFocus,
        ariaLabel = _this$props['aria-label'],
        ariaLabelledby = _this$props['aria-labelledby'],
        ariaDescribedby = _this$props['aria-describedby'];
      if (ref) {
        ref.setAttribute('id', listId);
        ref.setAttribute('role', 'listbox');
        if (searchable !== true) {
          ref.setAttribute('tabindex', '0');
          if (singleSelection !== 'always' && singleSelection !== true) {
            ref.setAttribute('aria-multiselectable', 'true');
          }
        }
        if (typeof ariaLabel === 'string') {
          ref.setAttribute('aria-label', ariaLabel);
        } else if (typeof ariaLabelledby === 'string') {
          ref.setAttribute('aria-labelledby', ariaLabelledby);
        }
        if (typeof ariaDescribedby === 'string') {
          ref.setAttribute('aria-describedby', ariaDescribedby);
        }
        if (autoFocus === true) {
          // manually focus listbox once available
          // use last stack execution to prevent potential focus order issues
          setTimeout(function () {
            return ref.focus();
          });
        }
      }
    });
    // This utility is necessary to exclude group labels from the aria set count
    _defineProperty(_this, "calculateAriaSetAttrs", function (optionArray) {
      var ariaPosInSetMap = {};
      var latestAriaPosIndex = 0;
      optionArray.forEach(function (option, index) {
        if (!option.isGroupLabel) {
          latestAriaPosIndex++;
          ariaPosInSetMap[index] = latestAriaPosIndex;
        }
      });
      return {
        ariaPosInSetMap: ariaPosInSetMap,
        ariaSetSize: latestAriaPosIndex
      };
    });
    _defineProperty(_this, "ListRow", /*#__PURE__*/memo(function (_ref) {
      var _option$textWrap;
      var data = _ref.data,
        index = _ref.index,
        style = _ref.style;
      var option = data[index];
      var optionData = option.data,
        _option = _objectWithoutProperties(option, _excluded);
      var label = option.label,
        isGroupLabel = option.isGroupLabel,
        checked = option.checked,
        disabled = option.disabled,
        prepend = option.prepend,
        append = option.append,
        ref = option.ref,
        key = option.key,
        searchableLabel = option.searchableLabel,
        _data = option.data,
        _truncationProps = option.truncationProps,
        optionRest = _objectWithoutProperties(option, _excluded2);
      var _this$props2 = _this.props,
        activeOptionIndex = _this$props2.activeOptionIndex,
        allowExclusions = _this$props2.allowExclusions,
        onFocusBadge = _this$props2.onFocusBadge,
        paddingSize = _this$props2.paddingSize,
        showIcons = _this$props2.showIcons,
        makeOptionId = _this$props2.makeOptionId,
        renderOption = _this$props2.renderOption,
        setActiveOptionIndex = _this$props2.setActiveOptionIndex,
        searchable = _this$props2.searchable,
        searchValue = _this$props2.searchValue,
        isPreFiltered = _this$props2.isPreFiltered,
        isVirtualized = _this$props2.isVirtualized;
      if (isGroupLabel) {
        return ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
          var styles = stylesMemoizer(euiSelectableListStyles);
          return ___EmotionJSX("li", _extends({
            role: "presentation",
            css: styles.euiSelectableList__groupLabel,
            className: "euiSelectableList__groupLabel",
            style: style
          }, optionRest), prepend, label, append);
        });
      }
      var id = makeOptionId(index);
      var isFocused = activeOptionIndex === index;

      // Search highlighting
      var hasSearch = !!searchValue;
      var highlightSearch = hasSearch && (_typeof(isPreFiltered) === 'object' ? isPreFiltered.highlightSearch !== false : true);

      // Text wrapping
      var canWrap = !isVirtualized;
      var _textWrap = (_option$textWrap = option.textWrap) !== null && _option$textWrap !== void 0 ? _option$textWrap : _this.props.textWrap;
      var textWrap = canWrap ? _textWrap : 'truncate';

      // Truncation config (if any). If none, CSS truncation is used
      var truncationProps = textWrap === 'truncate' ? _this.getTruncationProps(option, highlightSearch, isFocused) : undefined;
      return ___EmotionJSX(EuiSelectableListItem, _extends({
        key: id,
        id: id,
        style: style,
        onMouseDown: function onMouseDown() {
          setActiveOptionIndex(index);
        },
        onClick: function onClick(event) {
          event.persist(); // NOTE: This is needed for React v16 backwards compatibility
          _this.onAddOrRemoveOption(option, event);
        },
        isFocused: isFocused,
        title: searchableLabel || label,
        checked: checked,
        disabled: disabled,
        prepend: prepend,
        append: append,
        "aria-posinset": _this.state.ariaPosInSetMap[index],
        "aria-setsize": _this.state.ariaSetSize,
        onFocusBadge: onFocusBadge,
        allowExclusions: allowExclusions,
        showIcons: showIcons,
        paddingSize: paddingSize,
        searchable: searchable,
        textWrap: textWrap
        // @ts-ignore complex
      }, optionRest), renderOption ? renderOption( // @ts-ignore complex
      _objectSpread(_objectSpread({}, _option), optionData), searchValue) : highlightSearch ? _this.renderSearchedText(label, truncationProps) : truncationProps ? _this.renderTruncatedText(label, truncationProps) : label);
    }, areEqual));
    _defineProperty(_this, "renderVirtualizedList", function (listClasses) {
      if (!_this.props.isVirtualized) return null;
      var _this$state = _this.state,
        optionArray = _this$state.optionArray,
        itemData = _this$state.itemData;
      var _this$props3 = _this.props,
        windowProps = _this$props3.windowProps,
        forcedHeight = _this$props3.height,
        rowHeight = _this$props3.rowHeight;
      var heightIsFull = forcedHeight === 'full';
      var virtualizationProps = _objectSpread({
        className: listClasses,
        ref: _this.setListRef,
        outerRef: _this.removeScrollableTabStop,
        innerRef: _this.setListBoxRef,
        innerElementType: 'ul',
        itemCount: optionArray.length,
        itemData: itemData,
        itemSize: rowHeight,
        'data-skip-axe': 'scrollable-region-focusable'
      }, windowProps);

      // Calculated height is only used if height is not full
      var calculatedHeight = !heightIsFull ? forcedHeight || 0 : 0;

      // If calculatedHeight is still falsy, then calculate it
      if (!heightIsFull && !calculatedHeight) {
        var maxVisibleOptions = 7;
        var numVisibleOptions = optionArray.length;
        var numVisibleMoreThanMax = optionArray.length > maxVisibleOptions;
        if (numVisibleMoreThanMax) {
          // Show only half of the last one to indicate there's more to scroll to
          calculatedHeight = (maxVisibleOptions - 0.5) * rowHeight;
        } else {
          calculatedHeight = numVisibleOptions * rowHeight;
        }
      }
      return heightIsFull ? ___EmotionJSX(EuiAutoSizer, {
        onResize: _this.calculateDefaultOptionWidth
      }, function (_ref2) {
        var width = _ref2.width,
          height = _ref2.height;
        return ___EmotionJSX(FixedSizeList, _extends({
          width: width,
          height: height
        }, virtualizationProps), _this.ListRow);
      }) : ___EmotionJSX(EuiAutoSizer, {
        disableHeight: true,
        onResize: _this.calculateDefaultOptionWidth
      }, function (_ref3) {
        var width = _ref3.width;
        return ___EmotionJSX(FixedSizeList, _extends({
          width: width,
          height: calculatedHeight
        }, virtualizationProps), _this.ListRow);
      });
    });
    _defineProperty(_this, "forceVirtualizedListRowRerender", function () {
      _this.setState({
        itemData: _objectSpread({}, _this.state.optionArray)
      });
    });
    // EuiTextTruncate is expensive perf-wise - we use several utilities here to
    // offset its performance cost
    // and creates a resize observer for
    // each individual item. This logic tries to offset this performance hit by
    // guesstimating a default width for each option
    _defineProperty(_this, "focusBadgeOffset", 0);
    _defineProperty(_this, "calculateDefaultOptionWidth", function (_ref4) {
      var containerWidth = _ref4.width;
      var _this$props4 = _this.props,
        truncationProps = _this$props4.truncationProps,
        searchable = _this$props4.searchable,
        searchValue = _this$props4.searchValue;

      // If it's not likely we'll need to use EuiTextTruncate, don't set state/rerender on every panel resize
      var mayTruncate = searchable || truncationProps;
      if (!mayTruncate) return;
      var paddingOffset = _this.props.paddingSize === 'none' ? 0 : 24; // Defaults to 's'
      var checkedIconOffset = _this.props.showIcons === false ? 0 : 28; // Defaults to true
      _this.focusBadgeOffset = _this.props.onFocusBadge === false ? 0 : 46;

      // Wait a tick for the listbox ref to update before proceeding
      _this.animationFrameId = requestAnimationFrame(function () {
        var scrollbarOffset = _this.listBoxRef ? containerWidth - _this.listBoxRef.offsetWidth : 0;
        _this.setState({
          defaultOptionWidth: containerWidth - scrollbarOffset - paddingOffset - checkedIconOffset
        });

        // Potentially force list rows to rerender on dynamic resize as well,
        // but try to do it as lightly as possible
        if (truncationProps || searchable && searchValue) {
          _this.forceVirtualizedListRowRerender();
        }
      });
    });
    _defineProperty(_this, "getTruncationProps", function (option, highlightSearch, isFocused) {
      // Individual truncation settings should override component-wide settings
      var truncationProps = _objectSpread(_objectSpread({}, _this.props.truncationProps), option.truncationProps);

      // If we're not actually using EuiTextTruncate, no need to continue
      var hasComplexTruncation = highlightSearch || Object.keys(truncationProps).length > 0;
      if (!hasComplexTruncation) return undefined;

      // Determine whether we can use the optimized default option width
      var defaultOptionWidth = _this.state.defaultOptionWidth;
      var useDefaultWidth = !option.append && !option.prepend;
      var defaultWidth = useDefaultWidth && defaultOptionWidth ? isFocused ? defaultOptionWidth - _this.focusBadgeOffset : defaultOptionWidth : undefined;
      return _objectSpread({
        width: defaultWidth
      }, truncationProps);
    });
    _defineProperty(_this, "renderSearchedText", function (text, truncationProps) {
      var searchValue = _this.props.searchValue;

      // If truncationProps is undefined, we're using non-virtualized text wrapping
      if (!truncationProps) {
        return ___EmotionJSX(EuiHighlight, {
          search: searchValue
        }, text);
      }
      var searchPositionStart = text.toLowerCase().indexOf(searchValue.toLowerCase());
      var searchPositionCenter = searchPositionStart + Math.floor(searchValue.length / 2);
      return ___EmotionJSX(EuiTextTruncate, _extends({}, truncationProps, {
        // When searching, don't allow overriding the truncation settings
        truncation: "startEnd",
        truncationPosition: searchPositionCenter,
        text: text
      }), function (text) {
        return ___EmotionJSX(React.Fragment, null, text.length >= searchValue.length ? ___EmotionJSX(EuiHighlight, {
          search: searchValue
        }, text) :
        // If the available truncated text is shorter than the full search string,
        // just highlight the entire truncated text
        ___EmotionJSX(EuiMark, null, text));
      });
    });
    _defineProperty(_this, "renderTruncatedText", function (text, truncationProps) {
      return (
        // For some bizarre reason, truncation in EuiSelectable is off on initial mount
        // (but not on rerender) for Safari and _some_ truncation types in Firefox :|
        // Waiting a tick before calculating truncation seems to smooth over the issue
        ___EmotionJSX(EuiTextTruncate, _extends({
          calculationDelayMs: 2
        }, truncationProps, {
          text: text
        }), function (text) {
          return text;
        })
      );
    });
    _defineProperty(_this, "onAddOrRemoveOption", function (option, event) {
      if (option.disabled) {
        return;
      }
      var _this$props5 = _this.props,
        allowExclusions = _this$props5.allowExclusions,
        options = _this$props5.options,
        _this$props5$visibleO = _this$props5.visibleOptions,
        visibleOptions = _this$props5$visibleO === void 0 ? options : _this$props5$visibleO;
      _this.props.setActiveOptionIndex(visibleOptions.findIndex(function (_ref5) {
        var label = _ref5.label;
        return label === option.label;
      }), function () {
        if (option.checked === 'on' && allowExclusions) {
          _this.onExcludeOption(option, event);
        } else if (option.checked === 'on' || option.checked === 'off') {
          _this.onRemoveOption(option, event);
        } else {
          _this.onAddOption(option, event);
        }
      });
    });
    _defineProperty(_this, "onAddOption", function (addedOption, event) {
      var _this$props6 = _this.props,
        onOptionClick = _this$props6.onOptionClick,
        options = _this$props6.options,
        singleSelection = _this$props6.singleSelection;
      var changedOption = _objectSpread({}, addedOption);
      var updatedOptions = options.map(function (option) {
        // if singleSelection is enabled, uncheck any selected option(s)
        var updatedOption = _objectSpread({}, option);
        if (singleSelection) {
          delete updatedOption.checked;
        }

        // if this is the now-selected option, check it
        if (option === addedOption) {
          updatedOption.checked = 'on';
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    _defineProperty(_this, "onRemoveOption", function (removedOption, event) {
      var _this$props7 = _this.props,
        onOptionClick = _this$props7.onOptionClick,
        singleSelection = _this$props7.singleSelection,
        options = _this$props7.options;
      var changedOption = _objectSpread({}, removedOption);
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);
        if (option === removedOption && singleSelection !== 'always') {
          delete updatedOption.checked;
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    _defineProperty(_this, "onExcludeOption", function (excludedOption, event) {
      var _this$props8 = _this.props,
        onOptionClick = _this$props8.onOptionClick,
        options = _this$props8.options;
      var changedOption = _objectSpread({}, excludedOption);
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);
        if (option === excludedOption) {
          updatedOption.checked = 'off';
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    var _optionArray = props.visibleOptions || props.options;
    _this.state = _objectSpread({
      defaultOptionWidth: 0,
      optionArray: _optionArray,
      itemData: _objectSpread({}, _optionArray)
    }, _this.calculateAriaSetAttrs(_optionArray));
    return _this;
  }
  _inherits(EuiSelectableList, _Component);
  return _createClass(EuiSelectableList, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      // ensure requestAnimationFrame is canceled on unmount as
      // it could potentially run on a next tick otherwise
      if (this.animationFrameId !== undefined) {
        cancelAnimationFrame(this.animationFrameId);
        this.animationFrameId = undefined;
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      var _this$props9 = this.props,
        allowExclusions = _this$props9.allowExclusions,
        showIcons = _this$props9.showIcons,
        paddingSize = _this$props9.paddingSize,
        textWrap = _this$props9.textWrap,
        onFocusBadge = _this$props9.onFocusBadge,
        searchable = _this$props9.searchable;

      // using shouldComponentUpdate to determine needed rerender before actual rerender
      // without needing state updates or lagging behind on updates
      if (nextProps.allowExclusions !== allowExclusions || nextProps.showIcons !== showIcons || nextProps.paddingSize !== paddingSize || nextProps.textWrap !== textWrap || nextProps.onFocusBadge !== onFocusBadge || nextProps.searchable !== searchable) {
        this.listRowRerender += 1;
      }
      return true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props10 = this.props,
        isVirtualized = _this$props10.isVirtualized,
        activeOptionIndex = _this$props10.activeOptionIndex,
        visibleOptions = _this$props10.visibleOptions,
        options = _this$props10.options,
        allowExclusions = _this$props10.allowExclusions,
        showIcons = _this$props10.showIcons,
        paddingSize = _this$props10.paddingSize,
        textWrap = _this$props10.textWrap,
        onFocusBadge = _this$props10.onFocusBadge,
        searchable = _this$props10.searchable;
      if (prevProps.activeOptionIndex !== activeOptionIndex) {
        var makeOptionId = this.props.makeOptionId;
        if (this.listBoxRef && this.props.searchable !== true) {
          this.listBoxRef.setAttribute('aria-activedescendant', makeOptionId(activeOptionIndex));
        }
        if (typeof activeOptionIndex !== 'undefined') {
          if (isVirtualized) {
            var _this$listRef;
            (_this$listRef = this.listRef) === null || _this$listRef === void 0 || _this$listRef.scrollToItem(activeOptionIndex, 'auto');
          } else {
            var _this$listBoxRef;
            var activeOptionId = "#".concat(makeOptionId(activeOptionIndex));
            var activeOptionEl = (_this$listBoxRef = this.listBoxRef) === null || _this$listBoxRef === void 0 ? void 0 : _this$listBoxRef.querySelector(activeOptionId);
            if (activeOptionEl) {
              var _activeOptionEl$scrol;
              // TODO: we can remove scrollIntoView's conditional chaining once jsdom stubs it
              // @see https://github.com/jsdom/jsdom/issues/1695
              (_activeOptionEl$scrol = activeOptionEl.scrollIntoView) === null || _activeOptionEl$scrol === void 0 || _activeOptionEl$scrol.call(activeOptionEl, {
                block: 'nearest'
              });
            }
          }
        }
      }
      var optionArray = visibleOptions || options;
      if (prevProps.visibleOptions !== visibleOptions || prevProps.options !== options) {
        this.setState(_objectSpread({
          optionArray: optionArray,
          itemData: _objectSpread({}, optionArray)
        }, this.calculateAriaSetAttrs(optionArray)));
      } else if (isVirtualized) {
        // ensure that ListRow updates based on item props
        if (prevProps.allowExclusions !== allowExclusions || prevProps.showIcons !== showIcons || prevProps.paddingSize !== paddingSize || prevProps.textWrap !== textWrap || prevProps.onFocusBadge !== onFocusBadge || prevProps.searchable !== searchable) {
          this.setState({
            itemData: _objectSpread({}, optionArray)
          });
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props11 = this.props,
        className = _this$props11.className,
        options = _this$props11.options,
        searchValue = _this$props11.searchValue,
        onOptionClick = _this$props11.onOptionClick,
        renderOption = _this$props11.renderOption,
        forcedHeight = _this$props11.height,
        windowProps = _this$props11.windowProps,
        rowHeight = _this$props11.rowHeight,
        activeOptionIndex = _this$props11.activeOptionIndex,
        makeOptionId = _this$props11.makeOptionId,
        showIcons = _this$props11.showIcons,
        singleSelection = _this$props11.singleSelection,
        visibleOptions = _this$props11.visibleOptions,
        allowExclusions = _this$props11.allowExclusions,
        bordered = _this$props11.bordered,
        paddingSize = _this$props11.paddingSize,
        searchable = _this$props11.searchable,
        onFocusBadge = _this$props11.onFocusBadge,
        listId = _this$props11.listId,
        setActiveOptionIndex = _this$props11.setActiveOptionIndex,
        ariaLabel = _this$props11['aria-label'],
        ariaLabelledby = _this$props11['aria-labelledby'],
        ariaDescribedby = _this$props11['aria-describedby'],
        role = _this$props11.role,
        isPreFiltered = _this$props11.isPreFiltered,
        isVirtualized = _this$props11.isVirtualized,
        textWrap = _this$props11.textWrap,
        truncationProps = _this$props11.truncationProps,
        autoFocus = _this$props11.autoFocus,
        rest = _objectWithoutProperties(_this$props11, _excluded3);
      var heightIsFull = forcedHeight === 'full';
      var classes = classNames('euiSelectableList', className);
      return ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(euiSelectableListStyles);
        var cssStyles = [styles.euiSelectableList, heightIsFull && styles.fullHeight, bordered && styles.bordered];
        var listClasses = classNames('euiSelectableList__list', styles.euiSelectableList__list);
        return ___EmotionJSX("div", _extends({
          css: cssStyles,
          className: classes
        }, rest), isVirtualized ? _this2.renderVirtualizedList(listClasses) : ___EmotionJSX("div", {
          className: listClasses,
          style: !heightIsFull ? {
            blockSize: forcedHeight
          } : undefined,
          ref: _this2.removeScrollableTabStop
        }, ___EmotionJSX("ul", {
          ref: _this2.setListBoxRef
        }, _this2.state.optionArray.map(function (_, index) {
          return /*#__PURE__*/React.createElement(_this2.ListRow, {
            key: "".concat(index, "-").concat(_this2.listRowRerender),
            data: _this2.state.optionArray,
            index: index
          }, null);
        }))));
      });
    }
  }]);
}(Component);
_defineProperty(EuiSelectableList, "defaultProps", {
  rowHeight: 32,
  searchValue: '',
  isVirtualized: true
});