import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap", "toolTipContent", "toolTipProps", "aria-describedby"],
  _excluded2 = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React, { useState, useEffect, useMemo } from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiBadge } from '../../badge';
import { EuiToolTip } from '../../tool_tip';
import { euiSelectableListItemStyles } from './selectable_list_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
function resolveIconAndColor(checked) {
  switch (checked) {
    case 'on':
      return {
        icon: 'check',
        color: 'text'
      };
    case 'off':
      return {
        icon: 'cross',
        color: 'text'
      };
    case 'mixed':
      return {
        icon: 'minus',
        color: 'text'
      };
    case undefined:
    default:
      return {
        icon: 'empty'
      };
  }
}
export var PADDING_SIZES = ['none', 's'];
export var EuiSelectableListItem = function EuiSelectableListItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    disabled = _ref.disabled,
    checked = _ref.checked,
    isFocused = _ref.isFocused,
    _ref$showIcons = _ref.showIcons,
    showIcons = _ref$showIcons === void 0 ? true : _ref$showIcons,
    prepend = _ref.prepend,
    append = _ref.append,
    allowExclusions = _ref.allowExclusions,
    _ref$onFocusBadge = _ref.onFocusBadge,
    onFocusBadge = _ref$onFocusBadge === void 0 ? true : _ref$onFocusBadge,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 's' : _ref$paddingSize,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'option' : _ref$role,
    searchable = _ref.searchable,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'truncate' : _ref$textWrap,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSelectableListItem', {
    'euiSelectableListItem-isFocused': isFocused
  }, className);
  var styles = useEuiMemoizedStyles(euiSelectableListItemStyles);
  var cssStyles = [styles.euiSelectableListItem, styles.padding[paddingSize]];
  var textStyles = [styles.euiSelectableListItem__text, styles.textWrap[textWrap]];
  var optionIcon = useMemo(function () {
    if (showIcons) {
      var _resolveIconAndColor = resolveIconAndColor(checked),
        icon = _resolveIconAndColor.icon,
        color = _resolveIconAndColor.color;
      return ___EmotionJSX(EuiIcon, {
        css: styles.euiSelectableListItem__icon,
        className: "euiSelectableListItem__icon",
        color: color,
        type: icon
      });
    }
  }, [showIcons, checked, styles]);
  var prependNode = useMemo(function () {
    if (prepend) {
      return ___EmotionJSX("span", {
        css: styles.euiSelectableListItem__prepend,
        className: "euiSelectableListItem__prepend"
      }, prepend);
    }
  }, [prepend, styles]);
  var onFocusBadgeNode = useMemo(function () {
    var defaultOnFocusBadgeProps = {
      'aria-hidden': true,
      iconType: 'returnKey',
      iconSide: 'left',
      color: 'hollow'
    };
    if (onFocusBadge === true) {
      return ___EmotionJSX(EuiBadge, _extends({
        className: "euiSelectableListItem__onFocusBadge"
      }, defaultOnFocusBadgeProps));
    } else if (typeof onFocusBadge !== 'boolean' && !!onFocusBadge) {
      var _children = onFocusBadge.children,
        _className = onFocusBadge.className,
        restBadgeProps = _objectWithoutProperties(onFocusBadge, _excluded2);
      return ___EmotionJSX(EuiBadge, _extends({
        className: classNames('euiSelectableListItem__onFocusBadge', _className)
      }, defaultOnFocusBadgeProps, restBadgeProps), _children);
    }
  }, [onFocusBadge]);
  var showOnFocusBadge = !!(isFocused && !disabled && onFocusBadgeNode);
  var appendNode = useMemo(function () {
    if (append || showOnFocusBadge) {
      return ___EmotionJSX("span", {
        css: styles.euiSelectableListItem__append,
        className: "euiSelectableListItem__append"
      }, append, " ", showOnFocusBadge ? onFocusBadgeNode : null);
    }
  }, [append, showOnFocusBadge, onFocusBadgeNode, styles]);
  var screenReaderText = useMemo(function () {
    var state;
    var instructions;
    var screenReaderStrings = {
      checked: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkOptionInstructions",
          default: "To check this option, press Enter."
        })
      },
      unchecked: {
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.uncheckOptionInstructions",
          default: "To uncheck this option, press Enter."
        })
      },
      excluded: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludeOptionInstructions",
          default: "To exclude this option, press Enter."
        })
      },
      mixed: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOption",
          default: "Mixed (indeterminate) option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionInstructions",
          default: "To check this option for all, press Enter once."
        }),
        uncheckInstructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionUncheckInstructions",
          default: "To uncheck this option for all, press Enter twice."
        }),
        excludeInstructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionExcludeInstructions",
          default: "To exclude this option for all, press Enter twice."
        })
      }
    };
    switch (checked) {
      case 'on':
        state = screenReaderStrings.checked.state;
        instructions = allowExclusions ? screenReaderStrings.excluded.instructions : searchable ? screenReaderStrings.unchecked.instructions : undefined;
        break;
      case 'off':
        state = screenReaderStrings.excluded.state;
        instructions = screenReaderStrings.unchecked.instructions;
        break;
      case 'mixed':
        state = screenReaderStrings.mixed.state;
        instructions = ___EmotionJSX(React.Fragment, null, screenReaderStrings.mixed.instructions, ' ', allowExclusions ? screenReaderStrings.mixed.excludeInstructions : screenReaderStrings.mixed.uncheckInstructions);
        break;
      case undefined:
      default:
        instructions = allowExclusions || searchable ? screenReaderStrings.checked.instructions : undefined;
        break;
    }
    return state || instructions ? ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", null, state || instructions ? '. ' : null, state, state && instructions ? ' ' : null, instructions)) : null;
  }, [checked, searchable, allowExclusions]);

  // aria-checked is intended to be used with role="checkbox" but
  // the MDN documentation lists it as a possibility for role="option".
  // See https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked
  // and https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/option_role
  var ariaChecked = useMemo(function () {
    var rolesThatCanBeMixed = ['option', 'checkbox', 'menuitemcheckbox'];
    var rolesThatCanBeChecked = [].concat(rolesThatCanBeMixed, ['radio', 'menuitemradio', 'switch']);
    if (!rolesThatCanBeChecked.includes(role)) return undefined;
    switch (checked) {
      case 'on':
      case 'off':
        return true;
      case 'mixed':
        if (rolesThatCanBeMixed.includes(role)) {
          return 'mixed';
        } else {
          return false;
        }
      default:
        return false;
    }
  }, [role, checked]);
  var hasToolTip = !!toolTipContent && !disabled;
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    tooltipRef = _useState2[0],
    setTooltipRef = _useState2[1]; // Needs to be state and not a ref to trigger useEffect
  var _useState3 = useState(_ariaDescribedBy),
    _useState4 = _slicedToArray(_useState3, 2),
    ariaDescribedBy = _useState4[0],
    setAriaDescribedBy = _useState4[1];

  // Manually trigger the tooltip on keyboard focus
  useEffect(function () {
    if (!tooltipRef) return;
    if (isFocused) {
      tooltipRef.showToolTip();
    } else {
      tooltipRef.hideToolTip();
    }
  }, [isFocused, tooltipRef]);

  // Manually set the `aria-describedby` id on the <li> wrapper
  useEffect(function () {
    if (tooltipRef) {
      var tooltipId = tooltipRef.state.id;
      setAriaDescribedBy(classNames(tooltipId, _ariaDescribedBy));
    }
  }, [tooltipRef, _ariaDescribedBy]);
  var content = ___EmotionJSX("span", {
    css: styles.euiSelectableListItem__content,
    className: "euiSelectableListItem__content"
  }, optionIcon, prependNode, ___EmotionJSX("span", {
    css: textStyles,
    className: "euiSelectableListItem__text"
  }, children, screenReaderText), appendNode);
  return ___EmotionJSX("li", _extends({
    role: role,
    "aria-disabled": disabled,
    "aria-checked": ariaChecked // Whether the item is "checked"
    ,
    "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
    ,
    css: cssStyles,
    className: classes
  }, rest, {
    "aria-describedby": ariaDescribedBy
  }), hasToolTip ? ___EmotionJSX(EuiToolTip, _extends({
    ref: setTooltipRef,
    content: toolTipContent,
    anchorClassName: "eui-fullWidth",
    position: "left"
  }, toolTipProps), content) : content);
};