function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../../services';
import { euiFontSize, euiTextTruncate, logicalCSS } from '../../../global_styling';
export var euiSelectableListItemVariables = function euiSelectableListItemVariables(_ref2) {
  var euiTheme = _ref2.euiTheme;
  var lighterBorder = transparentize(euiTheme.border.color, 0.4);
  return {
    border: "".concat(euiTheme.border.width.thin, " solid ").concat(lighterBorder),
    paddingHorizontal: euiTheme.size.m,
    paddingVertical: euiTheme.size.xs
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1rnenrt-euiSelectableListItem__text",
  styles: "flex-grow:1;label:euiSelectableListItem__text;"
} : {
  name: "1rnenrt-euiSelectableListItem__text",
  styles: "flex-grow:1;label:euiSelectableListItem__text;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSelectableListItemStyles = function euiSelectableListItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiSelectableListIte = euiSelectableListItemVariables(euiThemeContext),
    border = _euiSelectableListIte.border,
    paddingHorizontal = _euiSelectableListIte.paddingHorizontal,
    paddingVertical = _euiSelectableListIte.paddingVertical;
  return {
    euiSelectableListItem: /*#__PURE__*/css("display:inline-flex;", logicalCSS('width', '100%'), " line-height:", euiFontSize(euiThemeContext, 'm').lineHeight, ";font-size:", euiFontSize(euiThemeContext, 's').fontSize, ";text-align:start;cursor:pointer;overflow:hidden;&:not(:last-of-type){", logicalCSS('border-bottom', border), ";}&[aria-disabled='true']{color:", euiTheme.colors.disabledText, ";cursor:not-allowed;}&:hover,&.euiSelectableListItem-isFocused{&:not([aria-disabled='true']){color:", euiTheme.colors.primaryText, ";background-color:", euiTheme.focus.backgroundColor, ";.euiSelectableListItem__text{text-decoration:underline;}}};label:euiSelectableListItem;"),
    padding: {
      none: /*#__PURE__*/css(";label:none;"),
      s: /*#__PURE__*/css(logicalCSS('padding-vertical', paddingVertical), " ", logicalCSS('padding-horizontal', paddingHorizontal), ";;label:s;")
    },
    // Child elements

    euiSelectableListItem__content: /*#__PURE__*/css(logicalCSS('width', '100%'), " display:flex;align-items:center;;label:euiSelectableListItem__content;"),
    euiSelectableListItem__text: _ref,
    textWrap: {
      truncate: /*#__PURE__*/css(euiTextTruncate(), ";label:truncate;"),
      wrap: /*#__PURE__*/css(";label:wrap;")
    },
    euiSelectableListItem__prepend: /*#__PURE__*/css("flex-shrink:0;", logicalCSS('margin-right', paddingHorizontal), ";;label:euiSelectableListItem__prepend;"),
    euiSelectableListItem__append: /*#__PURE__*/css("flex-shrink:0;", logicalCSS('margin-left', paddingHorizontal), ";;label:euiSelectableListItem__append;"),
    get euiSelectableListItem__icon() {
      return this.euiSelectableListItem__prepend;
    }
  };
};