import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["onChange", "options", "value", "placeholder", "isPreFiltered", "listId", "className", "optionMatcher"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import classNames from 'classnames';
import { EuiFieldSearch } from '../../form';
import { getMatchingOptions } from '../matching_options';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectableSearch = function EuiSelectableSearch(_ref) {
  var onChangeCallback = _ref.onChange,
    options = _ref.options,
    value = _ref.value,
    placeholder = _ref.placeholder,
    isPreFiltered = _ref.isPreFiltered,
    listId = _ref.listId,
    className = _ref.className,
    optionMatcher = _ref.optionMatcher,
    rest = _objectWithoutProperties(_ref, _excluded);
  var onChange = useCallback(function (e) {
    var searchValue = e.target.value;
    var matchingOptions = getMatchingOptions({
      options: options,
      searchValue: searchValue,
      isPreFiltered: isPreFiltered,
      optionMatcher: optionMatcher
    });
    onChangeCallback(searchValue, matchingOptions);
  }, [options, isPreFiltered, onChangeCallback, optionMatcher]);
  var classes = classNames('euiSelectableSearch', className);
  var ariaPropsIfListIsPresent = listId ? {
    role: 'combobox',
    'aria-autocomplete': 'list',
    'aria-expanded': true,
    'aria-controls': listId,
    'aria-owns': listId // legacy attribute but shims support for nearly everything atm
  } : undefined;
  return ___EmotionJSX(EuiFieldSearch, _extends({
    className: classes,
    placeholder: placeholder,
    value: value,
    onChange: onChange,
    incremental: true,
    fullWidth: true,
    autoComplete: "off",
    "aria-haspopup": "listbox"
  }, ariaPropsIfListIsPresent, rest));
};