import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["text", "highlightSearchString", "className"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { RenderWithEuiStylesMemoizer } from '../../../services';
import { EuiIcon } from '../../icon';
import { EuiAvatar } from '../../avatar';
import { EuiHighlight } from '../../highlight';
import { euiSelectableTemplateSitewideStyles } from './selectable_template_sitewide.styles';

/**
 * The generic extension allows consumers to keep their data objects
 * intact without needing to do key lookups when using `renderOption`
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var euiSelectableTemplateSitewideFormatOptions = function euiSelectableTemplateSitewideFormatOptions(options, styles) {
  return options.map(function (item) {
    var title = item.label;
    if (item.meta && item.meta.length) {
      title += " \u2022".concat(renderOptionMeta({
        meta: item.meta,
        stringsOnly: true,
        styles: styles
      }));
    }
    return _objectSpread(_objectSpread({
      key: item.label,
      title: title
    }, item), {}, {
      css: [styles.euiSelectableTemplateSitewide__listItem, item.css],
      className: classNames('euiSelectableTemplateSitewide__listItem', item.className),
      prepend: item.icon ? ___EmotionJSX(EuiIcon, _extends({
        color: "subdued",
        size: "l"
      }, item.icon)) : item.prepend,
      append: item.avatar ? ___EmotionJSX(EuiAvatar, _extends({
        type: "space",
        size: "s"
      }, item.avatar)) : item.append
    });
  });
};
export var euiSelectableTemplateSitewideRenderOptions = function euiSelectableTemplateSitewideRenderOptions(option, searchValue) {
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiHighlight, {
    className: "euiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
    var styles = stylesMemoizer(euiSelectableTemplateSitewideStyles);
    return renderOptionMeta({
      meta: option.meta,
      styles: styles,
      searchValue: searchValue
    });
  }));
};
var renderOptionMeta = function renderOptionMeta(_ref) {
  var meta = _ref.meta,
    styles = _ref.styles,
    _ref$searchValue = _ref.searchValue,
    searchValue = _ref$searchValue === void 0 ? '' : _ref$searchValue,
    _ref$stringsOnly = _ref.stringsOnly,
    stringsOnly = _ref$stringsOnly === void 0 ? false : _ref$stringsOnly;
  if (!meta || meta.length < 1) return;
  var metas = meta.map(function (meta) {
    var text = meta.text,
      highlightSearchString = meta.highlightSearchString,
      className = meta.className,
      rest = _objectWithoutProperties(meta, _excluded);
    if (stringsOnly) {
      return " ".concat(text);
    }

    // Start with the base and custom classes
    var metaClasses = classNames('euiSelectableTemplateSitewide__optionMeta', className);

    // If they provided a type, create the class and append
    if (meta.type) {
      metaClasses = classNames(["euiSelectableTemplateSitewide__optionMeta--".concat(meta.type)], metaClasses);
    }
    var hasMetaTypeStyles = function hasMetaTypeStyles(metaType) {
      return metaType in styles.metaTypes;
    };
    var cssStyles = [styles.euiSelectableTemplateSitewide__optionMeta].concat(_toConsumableArray(meta.type && hasMetaTypeStyles(meta.type) ? [styles.metaTypes.fontWeight, styles.metaTypes[meta.type]] : []));
    return ___EmotionJSX(EuiHighlight, _extends({
      search: highlightSearchString ? searchValue : '',
      css: cssStyles,
      className: metaClasses,
      key: text
    }, rest), text);
  });
  return stringsOnly ? metas : ___EmotionJSX("span", {
    css: styles.euiSelectableTemplateSitewide__optionMetasList,
    className: "euiSelectableTemplateSitewide__optionMetasList"
  }, metas);
};