import { css as _css } from "@emotion/react";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "id", "className", "element", "screenReaderOnly", "size", "textTransform"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiTitle } from '../title';
import { EuiScreenReaderOnly } from '../accessibility';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSideNavHeading = function EuiSideNavHeading(_ref) {
  var children = _ref.children,
    id = _ref.id,
    className = _ref.className,
    _ref$element = _ref.element,
    HeadingElement = _ref$element === void 0 ? 'h2' : _ref$element,
    _ref$screenReaderOnly = _ref.screenReaderOnly,
    screenReaderOnly = _ref$screenReaderOnly === void 0 ? false : _ref$screenReaderOnly,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'xs' : _ref$size,
    textTransform = _ref.textTransform,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSideNav__heading', className);
  var _useEuiTheme = useEuiTheme(),
    euiTheme = _useEuiTheme.euiTheme;
  return screenReaderOnly ? ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX(HeadingElement, _extends({
    id: id,
    className: classes
  }, rest), children)) : ___EmotionJSX(EuiTitle, {
    size: size,
    textTransform: textTransform
  }, ___EmotionJSX(HeadingElement, _extends({
    id: id,
    className: classes,
    css: /*#__PURE__*/_css({
      marginBlockEnd: euiTheme.size.l
    }, ";label:EuiSideNavHeading;")
  }, rest), children));
};