import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["id", "name", "isSelected", "items", "icon", "onClick", "href", "forceOpen"],
  _excluded2 = ["className", "items", "toggleOpenOnMobile", "isOpenOnMobile", "mobileTitle", "mobileBreakpoints", "renderItem", "truncate", "heading", "headingProps", "theme"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { EuiButtonEmpty } from '../button';
import { EuiI18n } from '../i18n';
import { htmlIdGenerator, withEuiTheme } from '../../services';
import { EuiHideFor, EuiShowFor } from '../responsive';
import { EuiSideNavHeading } from './_side_nav_heading';
import { EuiSideNavItem } from './side_nav_item';
import { euiSideNavMobileStyles } from './side_nav.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSideNavClass = /*#__PURE__*/function (_Component) {
  function EuiSideNavClass() {
    var _this;
    _classCallCheck(this, EuiSideNavClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSideNavClass, [].concat(args));
    _defineProperty(_this, "generateId", htmlIdGenerator('euiSideNav'));
    _defineProperty(_this, "isItemOpen", function (item) {
      // The developer can force the item to be open.
      if (item.forceOpen) {
        return true;
      }

      // Of course a selected item is open.
      if (item.isSelected) {
        return true;
      }

      // The item has to be open if it has a child that's open.
      if (item.items) {
        return item.items.some(_this.isItemOpen);
      }
      return false;
    });
    _defineProperty(_this, "renderTree", function (items) {
      var depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var _this$props = _this.props,
        renderItem = _this$props.renderItem,
        truncate = _this$props.truncate;
      return items.map(function (item) {
        var id = item.id,
          name = item.name,
          isSelected = item.isSelected,
          childItems = item.items,
          icon = item.icon,
          onClick = item.onClick,
          href = item.href,
          forceOpen = item.forceOpen,
          rest = _objectWithoutProperties(item, _excluded);

        // Root items are always open.
        var isOpen = depth === 0 ? true : _this.isItemOpen(item);
        var renderedItems;
        if (childItems) {
          renderedItems = _this.renderTree(childItems, depth + 1);
        }

        // Act as an accordion only if item is not linked but has children (and not the root)
        var childrenOnly = depth > 0 && !onClick && !href && !!childItems;
        return ___EmotionJSX(EuiSideNavItem, _extends({
          isOpen: isOpen,
          isSelected: !childrenOnly && isSelected,
          isParent: !!childItems,
          icon: icon,
          onClick: onClick,
          href: href,
          items: renderedItems,
          key: id,
          depth: depth,
          renderItem: renderItem,
          truncate: truncate,
          childrenOnly: childrenOnly
        }, rest), name);
      });
    });
    return _this;
  }
  _inherits(EuiSideNavClass, _Component);
  return _createClass(EuiSideNavClass, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        items = _this$props2.items,
        toggleOpenOnMobile = _this$props2.toggleOpenOnMobile,
        isOpenOnMobile = _this$props2.isOpenOnMobile,
        mobileTitle = _this$props2.mobileTitle,
        mobileBreakpoints = _this$props2.mobileBreakpoints,
        renderItem = _this$props2.renderItem,
        truncate = _this$props2.truncate,
        heading = _this$props2.heading,
        headingProps = _this$props2.headingProps,
        theme = _this$props2.theme,
        rest = _objectWithoutProperties(_this$props2, _excluded2);
      var classes = classNames('euiSideNav', className, {
        'euiSideNav-isOpenMobile': isOpenOnMobile
      });
      var styles = euiSideNavMobileStyles(theme);
      var contentClasses = classNames('euiSideNav__content');
      var sideNavContentId = this.generateId('content');
      var mobileContentStyles = [styles.content.euiSideNav__mobileContent, isOpenOnMobile ? styles.content.open : styles.content.hidden];
      var hasMobileVersion = mobileBreakpoints && mobileBreakpoints.length > 0;
      var mobileToggleText = mobileTitle || heading;
      var mobileHeadingUnset = {
        marginBlockEnd: 0,
        label: 'mobile'
      };
      var headingId = (headingProps === null || headingProps === void 0 ? void 0 : headingProps.id) || this.generateId('heading');
      var headingScreenReaderOnly = !!(headingProps !== null && headingProps !== void 0 && headingProps.screenReaderOnly);
      return ___EmotionJSX(React.Fragment, null, hasMobileVersion && ___EmotionJSX(EuiShowFor, {
        sizes: mobileBreakpoints || 'none'
      }, ___EmotionJSX("nav", _extends({
        "aria-labelledby": headingId,
        className: classes
      }, rest), ___EmotionJSX(EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps, {
        screenReaderOnly: false,
        css: mobileHeadingUnset
      }), ___EmotionJSX(EuiI18n, {
        token: "euiSideNav.mobileToggleAriaLabel",
        default: "Toggle navigation"
      }, function (mobileToggleAriaLabel) {
        return ___EmotionJSX(EuiButtonEmpty, {
          className: "euiSideNav__mobileToggle",
          css: styles.euiSideNav__mobileToggle,
          contentProps: {
            className: 'euiSideNav__mobileToggleContent',
            css: styles.euiSideNav__mobileToggleContent
          },
          onClick: toggleOpenOnMobile,
          iconType: "apps",
          iconSide: "right",
          "aria-controls": sideNavContentId,
          "aria-expanded": isOpenOnMobile,
          "aria-label": !mobileToggleText || headingScreenReaderOnly ? mobileToggleAriaLabel : undefined
        }, !headingScreenReaderOnly && mobileToggleText);
      })), ___EmotionJSX("div", {
        id: sideNavContentId,
        className: contentClasses,
        css: mobileContentStyles
      }, this.renderTree(items)))), ___EmotionJSX(EuiHideFor, {
        sizes: mobileBreakpoints || 'none'
      }, ___EmotionJSX("nav", _extends({
        "aria-labelledby": heading ? headingId : undefined,
        className: classes
      }, rest), heading && ___EmotionJSX(EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps), heading), ___EmotionJSX("div", {
        id: sideNavContentId,
        className: contentClasses
      }, this.renderTree(items)))));
    }
  }]);
}(Component);
_defineProperty(EuiSideNavClass, "defaultProps", {
  items: [],
  mobileBreakpoints: ['xs', 's']
});
export var EuiSideNav = withEuiTheme(EuiSideNavClass);