import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["href", "target", "rel", "onClick", "className", "children", "disabled"],
  _excluded2 = ["isOpen", "isSelected", "isParent", "icon", "onClick", "href", "rel", "target", "items", "children", "renderItem", "depth", "className", "css", "style", "truncate", "emphasize", "buttonClassName", "childrenOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useCallback } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, getSecureRelForTarget } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { EuiInnerText } from '../inner_text';
import { EuiIcon } from '../icon';
import { euiSideNavItemStyles, euiSideNavItemButtonStyles } from './side_nav_item.styles';

/**
 * The props that are exposed to, or altered for, the consumer
 * for use in the object of items in `EuiSideNav`
 * can be found in the `side_nave_types.ts` file.
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
var DefaultRenderItem = function DefaultRenderItem(_ref) {
  var href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    onClick = _ref.onClick,
    className = _ref.className,
    children = _ref.children,
    disabled = _ref.disabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  if (href && !disabled) {
    var secureRel = getSecureRelForTarget({
      href: href,
      rel: rel,
      target: target
    });
    return ___EmotionJSX("a", _extends({
      className: className,
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), children);
  }
  if (onClick || disabled) {
    return ___EmotionJSX("button", _extends({
      type: "button",
      className: className,
      onClick: onClick,
      disabled: disabled
    }, rest), children);
  }
  return ___EmotionJSX("div", _extends({
    className: className
  }, rest), children);
};
export var EuiSideNavItem = function EuiSideNavItem(_ref2) {
  var isOpen = _ref2.isOpen,
    isSelected = _ref2.isSelected,
    isParent = _ref2.isParent,
    icon = _ref2.icon,
    onClick = _ref2.onClick,
    _href = _ref2.href,
    rel = _ref2.rel,
    target = _ref2.target,
    items = _ref2.items,
    children = _ref2.children,
    _ref2$renderItem = _ref2.renderItem,
    RenderItem = _ref2$renderItem === void 0 ? DefaultRenderItem : _ref2$renderItem,
    _ref2$depth = _ref2.depth,
    depth = _ref2$depth === void 0 ? 0 : _ref2$depth,
    className = _ref2.className,
    css = _ref2.css,
    style = _ref2.style,
    _ref2$truncate = _ref2.truncate,
    truncate = _ref2$truncate === void 0 ? true : _ref2$truncate,
    emphasize = _ref2.emphasize,
    buttonClassName = _ref2.buttonClassName,
    childrenOnly = _ref2.childrenOnly,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var isHrefValid = !_href || validateHref(_href);
  var href = isHrefValid ? _href : '';

  // Forcing accordion style item if not linked, but has children
  var _useState = useState(isOpen),
    _useState2 = _slicedToArray(_useState, 2),
    itemIsOpen = _useState2[0],
    setItemIsOpen = _useState2[1];
  useEffect(function () {
    setItemIsOpen(isOpen);
  }, [isOpen]);
  var toggleItemOpen = useCallback(function () {
    setItemIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var isRoot = depth === 0;
  var isTrunk = depth === 1;
  var isBranch = depth > 1;
  var hasCaret = depth > 0 && childrenOnly;
  var hasChildItems = items && itemIsOpen;
  var classes = classNames('euiSideNavItem', {
    'euiSideNavItem--root': isRoot,
    'euiSideNavItem--trunk': isTrunk,
    'euiSideNavItem--branch': isBranch,
    'euiSideNavItem--emphasized': emphasize,
    'euiSideNavItem-hasChildItems': hasChildItems
  }, className);
  var styles = useEuiMemoizedStyles(euiSideNavItemStyles);
  var cssStyles = [styles.euiSideNavItem, isRoot && styles.root, isTrunk && styles.trunk, isBranch && styles.branch, emphasize && styles.emphasized, css];
  var itemsStyles = hasChildItems && [styles.items.euiSideNavItem__items, isRoot && icon && styles.items.rootWithIcon, isTrunk && styles.items.trunk, isBranch && styles.items.branch];
  var buttonClasses = classNames('euiSideNavItemButton', {
    'euiSideNavItemButton-isOpen': depth > 0 && itemIsOpen && !isSelected,
    'euiSideNavItemButton-isSelected': isSelected
  }, buttonClassName);
  var buttonStyles = useEuiMemoizedStyles(euiSideNavItemButtonStyles);
  var buttonCssStyles = [buttonStyles.euiSideNavItemButton, isSelected && buttonStyles.selected, emphasize && buttonStyles.emphasized, isRoot && buttonStyles.root, isTrunk && buttonStyles.trunk, isBranch && buttonStyles.branch];
  var labelCssStyles = [buttonStyles.label.euiSideNavItemButton__label, isRoot && buttonStyles.label.root];
  return ___EmotionJSX("div", {
    css: cssStyles,
    className: classes,
    style: style
  }, ___EmotionJSX(RenderItem, _extends({
    css: buttonCssStyles,
    className: buttonClasses,
    href: href,
    rel: rel,
    target: target,
    onClick: childrenOnly ? toggleItemOpen : onClick
  }, rest), ___EmotionJSX("span", {
    css: buttonStyles.euiSideNavItemButton__content,
    className: "euiSideNavItemButton__content"
  }, icon, ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
    return ___EmotionJSX("span", {
      ref: ref,
      title: truncate ? innerText : undefined,
      css: labelCssStyles,
      className: classNames('euiSideNavItemButton__label', {
        'eui-textTruncate': truncate
      })
    }, children);
  }), hasCaret && ___EmotionJSX(EuiIcon, {
    type: itemIsOpen ? 'arrowDown' : 'arrowRight',
    size: "s"
  }))), hasChildItems && ___EmotionJSX("div", {
    css: itemsStyles,
    className: "euiSideNavItem__items"
  }, items));
};