import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { euiFontSize, logicalCSS, mathWithUnits } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
export var euiSideNavItemStyles = function euiSideNavItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var emphasizedBackgroundColor = transparentize(euiTheme.colors.lightShade, 0.3);
  return {
    euiSideNavItem: /*#__PURE__*/css(";label:euiSideNavItem;"),
    emphasized: /*#__PURE__*/css("background-color:", emphasizedBackgroundColor, ";color:", euiTheme.colors.title, ";box-shadow:100px 0 0 0 ", emphasizedBackgroundColor, ",-100px 0 0 0 ", emphasizedBackgroundColor, ";& &{background-color:transparent;box-shadow:none;};label:emphasized;"),
    // Layout
    root: /*#__PURE__*/css(logicalCSS('padding-bottom', euiTheme.size.s), " &+&{", logicalCSS('margin-top', euiTheme.size.s), " ", logicalCSS('padding-top', euiTheme.size.s), ";};label:root;"),
    trunk: /*#__PURE__*/css("color:", euiTheme.colors.title, ";;label:trunk;"),
    branch: /*#__PURE__*/css("position:relative;color:", euiTheme.colors.subduedText, ";&::after{position:absolute;content:'';", logicalCSS('vertical', 0), " ", logicalCSS('left', 0), " ", logicalCSS('width', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";}&:last-of-type::after{", logicalCSS('height', euiTheme.size.m), ";};label:branch;"),
    items: {
      euiSideNavItem__items: /*#__PURE__*/css(";label:euiSideNavItem__items;"),
      rootWithIcon: /*#__PURE__*/css(logicalCSS('margin-left', euiTheme.size.l), ";;label:rootWithIcon;"),
      trunk: /*#__PURE__*/css(logicalCSS('width', '100%'), logicalCSS('margin-left', euiTheme.size.s), ";;label:trunk;"),
      branch: /*#__PURE__*/css(logicalCSS('margin-left', euiTheme.size.base), ";;label:branch;")
    }
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1nca8qt-euiSideNavItemButton__label",
  styles: "flex-grow:1;label:euiSideNavItemButton__label;"
} : {
  name: "1nca8qt-euiSideNavItemButton__label",
  styles: "flex-grow:1;label:euiSideNavItemButton__label;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSideNavItemButtonStyles = function euiSideNavItemButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var lineHeightOverride = euiFontSize(euiThemeContext, 'm').lineHeight;

  // Create padding around focus area without indenting the item itself.
  var paddingMarginOffset = "\n    padding-inline: ".concat(euiTheme.size.s, ";\n    ").concat(logicalCSS('margin-left', "-".concat(euiTheme.size.s)), "\n    ").concat(logicalCSS('width', "calc(100% + ".concat(mathWithUnits(euiTheme.size.s, function (x) {
    return x * 2;
  }), ")")), ";\n  ");
  return {
    euiSideNavItemButton: /*#__PURE__*/css("display:block;", logicalCSS('width', '100%'), "padding-block:", euiTheme.size.xxs, ";font-size:", euiFontSize(euiThemeContext, 's').fontSize, ";line-height:", lineHeightOverride, ";text-align:start;color:inherit;&:is(a, button):not(:disabled){&:hover{cursor:pointer;}&:hover,&:focus{.euiSideNavItemButton__label{text-decoration:underline;}}}&:disabled{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";};label:euiSideNavItemButton;"),
    selected: /*#__PURE__*/css("color:", euiTheme.colors.primaryText, ";font-weight:", euiTheme.font.weight.bold, ";.euiSideNavItemButton__label{text-decoration:underline;};label:selected;"),
    emphasized: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.bold, ";;label:emphasized;"),
    // Layout
    root: /*#__PURE__*/css(logicalCSS('margin-bottom', euiTheme.size.xs), " padding-block:0;", paddingMarginOffset, ";;label:root;"),
    trunk: /*#__PURE__*/css(paddingMarginOffset, ";;label:trunk;"),
    branch: /*#__PURE__*/css("position:relative;padding-inline:", euiTheme.size.s, ";&::after{position:absolute;content:'';", logicalCSS('top', euiTheme.size.m), " ", logicalCSS('left', 0), " ", logicalCSS('width', euiTheme.size.xs), " ", logicalCSS('height', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";};label:branch;"),
    // Child elements
    euiSideNavItemButton__content: /*#__PURE__*/css("display:flex;align-items:center;gap:", euiTheme.size.s, ";;label:euiSideNavItemButton__content;"),
    label: {
      euiSideNavItemButton__label: _ref,
      root: _objectSpread(_objectSpread({}, euiTitle(euiThemeContext, 'xxs')), {}, {
        lineHeight: lineHeightOverride,
        color: 'inherit'
      })
    }
  };
};