import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isLoading", "contentAriaLabel", "loadingContent", "loadedContent", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiScreenReaderLive } from '../accessibility/screen_reader_live';
import { useEuiI18n } from '../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSkeletonLoading = function EuiSkeletonLoading(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    contentAriaLabel = _ref.contentAriaLabel,
    _loadingContent = _ref.loadingContent,
    loadedContent = _ref.loadedContent,
    _ref$announceLoadingS = _ref.announceLoadingStatus,
    announceLoadingStatus = _ref$announceLoadingS === void 0 ? false : _ref$announceLoadingS,
    _ref$announceLoadedSt = _ref.announceLoadedStatus,
    announceLoadedStatus = _ref$announceLoadedSt === void 0 ? true : _ref$announceLoadedSt,
    ariaLiveProps = _ref.ariaLiveProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var loadedAriaLive = useEuiI18n('euiSkeletonLoading.loadedAriaText', 'Loaded {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingAriaLabel = useEuiI18n('euiSkeletonLoading.loadingAriaText', 'Loading {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingProps = {
    'aria-label': loadingAriaLabel,
    role: 'progressbar'
  };
  var loadingContent = /*#__PURE__*/React.cloneElement(_loadingContent, loadingProps);
  return ___EmotionJSX("div", _extends({
    "aria-busy": isLoading,
    "data-test-subj": "euiSkeletonLoadingAriaWrapper"
  }, rest), isLoading ? ___EmotionJSX(React.Fragment, null, announceLoadingStatus && ___EmotionJSX(EuiScreenReaderLive, ariaLiveProps, loadingAriaLabel), loadingContent) : ___EmotionJSX(React.Fragment, null, announceLoadedStatus && ___EmotionJSX(EuiScreenReaderLive, ariaLiveProps, loadedAriaLive), loadedContent));
};