import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isLoading", "borderRadius", "width", "height", "style", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { logicalStyles } from '../../global_styling';
import { EuiSkeletonLoading } from './skeleton_loading';
import { euiSkeletonRectangleStyles } from './skeleton_rectangle.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var RADIUS = ['s', 'm', 'none'];
export var EuiSkeletonRectangle = function EuiSkeletonRectangle(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 's' : _ref$borderRadius,
    _ref$width = _ref.width,
    width = _ref$width === void 0 ? '24px' : _ref$width,
    _ref$height = _ref.height,
    height = _ref$height === void 0 ? '24px' : _ref$height,
    style = _ref.style,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiSkeletonRectangleStyles);
  var cssStyles = [styles.euiSkeletonRectangle, styles[borderRadius]];
  return ___EmotionJSX(EuiSkeletonLoading, _extends({
    isLoading: isLoading,
    loadingContent: ___EmotionJSX("div", _extends({
      className: classNames('euiSkeletonRectangle', className),
      css: cssStyles,
      style: logicalStyles(_objectSpread(_objectSpread({}, style), {}, {
        width: width,
        height: height
      }))
    }, rest)),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};