import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isLoading", "lines", "size", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiSkeletonLoading } from './skeleton_loading';
import { euiSkeletonTextStyles } from './skeleton_text.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var LINES = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
export var EuiSkeletonText = function EuiSkeletonText(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$lines = _ref.lines,
    lines = _ref$lines === void 0 ? 3 : _ref$lines,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiSkeletonTextStyles);
  var cssStyles = useMemo(function () {
    return [styles.euiSkeletonText, styles[size]];
  }, [styles, size]);
  var lineElements = useMemo(function () {
    var lineElements = [];
    for (var i = 0; i < lines; i++) {
      lineElements.push(___EmotionJSX("span", {
        key: i,
        css: cssStyles
      }));
    }
    return lineElements;
  }, [lines, cssStyles]);
  return ___EmotionJSX(EuiSkeletonLoading, _extends({
    isLoading: isLoading,
    loadingContent: ___EmotionJSX("span", _extends({
      className: classNames('euiSkeletonText', className)
    }, rest), lineElements),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};