import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createElement, useMemo } from 'react';
import classNames from 'classnames';
import { EuiText } from '../text';
import { EuiTitle } from '../title/title';
import { useEuiI18n } from '../i18n';
import { useEuiMemoizedStyles } from '../../services';
import { euiStatStyles, euiStatTitleStyles } from './stat.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['default', 'subdued', 'primary', 'success', 'danger', 'accent'];
export var ALIGNMENTS = ['left', 'center', 'right'];
export var EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
    className = _ref.className,
    description = _ref.description,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$reverse = _ref.reverse,
    reverse = _ref$reverse === void 0 ? false : _ref$reverse,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
    title = _ref.title,
    _ref$titleColor = _ref.titleColor,
    titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$descriptionEleme = _ref.descriptionElement,
    descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiStat', className);
  var styles = useEuiMemoizedStyles(euiStatStyles);
  var cssStyles = [styles.euiStat, styles[textAlign]];
  var loadingStatsAriaLabel = useEuiI18n('euiStat.loadingText', 'Statistic is loading');
  var titleStyles = useEuiMemoizedStyles(euiStatTitleStyles);
  var titleDisplay = useMemo(function () {
    var isNamedTitleColor = COLORS.includes(titleColor);
    var titleCssStyles = [titleStyles.euiStat__title, isNamedTitleColor && titleStyles[titleColor], isLoading && titleStyles.isLoading];
    return ___EmotionJSX(EuiTitle, {
      size: titleSize,
      className: "euiStat__title",
      css: titleCssStyles,
      "aria-label": isLoading ? loadingStatsAriaLabel : undefined
    }, /*#__PURE__*/createElement(titleElement, isNamedTitleColor ? null : {
      style: {
        color: titleColor
      }
    }, isLoading ? '--' : title));
  }, [title, titleElement, titleColor, titleSize, titleStyles, isLoading, loadingStatsAriaLabel]);
  var descriptionDisplay = useMemo(function () {
    return ___EmotionJSX(EuiText, {
      size: "s",
      className: "euiStat__description"
    }, /*#__PURE__*/createElement(descriptionElement, null, description));
  }, [description, descriptionElement]);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, children);
};