import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { logicalTextAlignCSS, euiCanAnimate } from '../../global_styling';
export var euiStatStyles = function euiStatStyles() {
  return {
    euiStat: /*#__PURE__*/css(";label:euiStat;"),
    // Text align
    left: /*#__PURE__*/css(logicalTextAlignCSS('left'), " align-items:flex-start;;label:left;"),
    center: /*#__PURE__*/css(logicalTextAlignCSS('center'), " align-items:center;;label:center;"),
    right: /*#__PURE__*/css(logicalTextAlignCSS('right'), " align-items:flex-end;;label:right;")
  };
};
export var euiStatTitleStyles = function euiStatTitleStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiStat__title: /*#__PURE__*/css(";label:euiStat__title;"),
    // Colors
    default: /*#__PURE__*/css("color:", euiTheme.colors.fullShade, ";;label:default;"),
    subdued: /*#__PURE__*/css("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    primary: /*#__PURE__*/css("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/css("color:", euiTheme.colors.successText, ";;label:success;"),
    danger: /*#__PURE__*/css("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    accent: /*#__PURE__*/css("color:", euiTheme.colors.accentText, ";;label:accent;"),
    // Loading
    isLoading: /*#__PURE__*/css(euiCanAnimate, "{animation:", euiStatPulse, " 1.5s infinite ease-in-out;};label:isLoading;")
  };
};
var euiStatPulse = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% { opacity: 1; }\n  50% { opacity: .25; }\n  100% { opacity: 1; }\n"])));