import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "step", "title", "onClick", "disabled", "status", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React from 'react';
import { useEuiTheme } from '../../services';
import { EuiStepNumber } from './step_number';
import { useI18nCompleteStep, useI18nCurrentStep, useI18nDisabledStep, useI18nIncompleteStep, useI18nStep, useI18nWarningStep, useI18nErrorsStep, useI18nLoadingStep } from './step_strings';
import { euiStepHorizontalStyles, euiStepHorizontalNumberStyles, euiStepHorizontalTitleStyles } from './step_horizontal.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
// The titleSize map is not 1 to 1; small == xs on the titleSize map
var stepNumberSizeMap = {
  xs: 'none',
  s: 'xs',
  m: 'm'
};
export var EuiStepHorizontal = function EuiStepHorizontal(_ref) {
  var className = _ref.className,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    onClick = _ref.onClick,
    disabled = _ref.disabled,
    _ref$status = _ref.status,
    status = _ref$status === void 0 ? 'incomplete' : _ref$status,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  if (disabled) status = 'disabled';
  var classes = classNames('euiStepHorizontal', className);
  var euiTheme = useEuiTheme();
  var styles = euiStepHorizontalStyles(euiTheme);
  var cssStyles = [styles.euiStepHorizontal, styles[size], status === 'disabled' ? styles.disabled : styles.enabled];
  var numberStyles = euiStepHorizontalNumberStyles(euiTheme);
  var cssNumberStyles = [numberStyles.euiStepHorizontal__number];
  var titleStyles = euiStepHorizontalTitleStyles(euiTheme);
  var cssTitleStyles = [titleStyles.euiStepHorizontal__title, status === 'disabled' && titleStyles.disabled];
  var titleAttrsMap = {
    step: useI18nStep({
      number: step,
      title: title
    }),
    current: useI18nCurrentStep({
      number: step,
      title: title
    }),
    disabled: useI18nDisabledStep({
      number: step,
      title: title
    }),
    incomplete: useI18nIncompleteStep({
      number: step,
      title: title
    }),
    complete: useI18nCompleteStep({
      number: step,
      title: title
    }),
    warning: useI18nWarningStep({
      number: step,
      title: title
    }),
    danger: useI18nErrorsStep({
      number: step,
      title: title
    }),
    loading: useI18nLoadingStep({
      number: step,
      title: title
    })
  };
  var titleAttr = titleAttrsMap[status || 'step'];
  var onStepClick = function onStepClick(event) {
    if (!disabled) onClick(event);
  };
  return ___EmotionJSX("button", _extends({
    "aria-disabled": status === 'disabled' ? true : undefined,
    className: classes,
    title: titleAttr,
    onClick: onStepClick,
    disabled: disabled,
    css: cssStyles,
    "data-step-status": status
  }, rest), ___EmotionJSX(EuiStepNumber, {
    className: "euiStepHorizontal__number",
    status: status,
    number: step,
    titleSize: stepNumberSizeMap[size],
    css: cssNumberStyles
  }), ___EmotionJSX("span", {
    className: "euiStepHorizontal__title",
    css: cssTitleStyles
  }, title));
};