import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "status", "number", "titleSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React from 'react';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiIcon } from '../icon';
import { EuiLoadingSpinner } from '../loading';
import { useEuiTheme } from '../../services';
import { useI18nCompleteStep, useI18nDisabledStep, useI18nErrorsStep, useI18nIncompleteStep, useI18nStep, useI18nWarningStep, useI18nLoadingStep, useI18nCurrentStep } from './step_strings';
import { euiStepNumberStyles, euiStepNumberContentStyles } from './step_number.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var STATUS = ['incomplete', 'disabled', 'loading', 'warning', 'danger', 'complete', 'current'];
export var EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
    status = _ref.status,
    number = _ref.number,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var ariaLabelsMap = {
    step: useI18nStep({
      number: number
    }),
    current: useI18nCurrentStep({
      number: number
    }),
    incomplete: useI18nIncompleteStep({
      number: number
    }),
    complete: useI18nCompleteStep({
      number: number
    }),
    disabled: useI18nDisabledStep({
      number: number
    }),
    warning: useI18nWarningStep({
      number: number
    }),
    danger: useI18nErrorsStep({
      number: number
    }),
    loading: useI18nLoadingStep({
      number: number
    })
  };
  var classes = classNames('euiStepNumber', className);
  var euiTheme = useEuiTheme();
  var styles = euiStepNumberStyles(euiTheme);
  var cssStyles = [styles.euiStepNumber, styles[titleSize], status && styles[status]];
  var contentStyles = euiStepNumberContentStyles(euiTheme);
  var content;
  var screenReaderText;
  switch (status) {
    // Loading spinner
    case 'loading':
      {
        var iconSizeMap = {
          none: 'm',
          xs: 'l',
          s: 'xl',
          m: 'xl'
        };
        screenReaderText = ariaLabelsMap.loading;
        content = ___EmotionJSX(EuiLoadingSpinner, {
          className: "euiStepNumber__loader",
          size: iconSizeMap[titleSize]
        });
        break;
      }
    // Statuses with icons
    case 'danger':
    case 'warning':
    case 'complete':
      {
        var cssIconStyles = [contentStyles.euiStepNumber__icon, contentStyles[status],
        // EuiIcon does not support a xxs size so far,
        // we use custom sizing here instead
        titleSize === 'none' && contentStyles[titleSize]];
        var iconTypeMap = {
          danger: 'cross',
          warning: 'warning',
          complete: 'check'
        };
        var _iconSizeMap = {
          xxs: 's',
          xs: 's',
          s: 'm',
          m: 'm'
        };
        content = ___EmotionJSX(EuiIcon, {
          type: iconTypeMap[status],
          "aria-label": ariaLabelsMap[status],
          size: _iconSizeMap[titleSize],
          className: "euiStepNumber__icon",
          css: cssIconStyles
        });
        break;
      }
    // Statuses with numbers
    case 'incomplete':
    case 'current':
    case 'disabled':
    default:
      screenReaderText = ariaLabelsMap[status || 'step'];
      if (titleSize === 'none') {
        break;
      }
      var cssNumberStyles = [contentStyles.euiStepNumber__number, status && contentStyles[status]];
      content = ___EmotionJSX("span", {
        "aria-hidden": "true",
        className: "euiStepNumber__number",
        css: cssNumberStyles
      }, number);
      break;
  }
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), screenReaderText && ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, screenReaderText)), content);
};