import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "steps", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React from 'react';
import { EuiStepHorizontal } from './step_horizontal';
import { euiStepsHorizontalStyles } from './steps_horizontal.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
    steps = _ref.steps,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiStepsHorizontal', className);
  var styles = euiStepsHorizontalStyles();
  var cssStyles = styles.euiStepsHorizontal;
  var cssItemStyles = styles.euiStepsHorizontal__item;
  return ___EmotionJSX("ol", _extends({
    className: classes,
    css: cssStyles
  }, rest), steps.map(function (stepProps, index) {
    return ___EmotionJSX("li", {
      key: index,
      className: "euiStepsHorizontal__item",
      css: cssItemStyles,
      "aria-current": stepProps.status === 'current' ? 'step' : undefined
    }, ___EmotionJSX(EuiStepHorizontal, _extends({
      step: index + 1,
      size: size
    }, stepProps)));
  }));
};