import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "align", "textOnly", "truncateText", "hasActions"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { LEFT_ALIGNMENT, useEuiMemoizedStyles } from '../../services';
import { isObject } from '../../services/predicate';
import { EuiTextBlockTruncate } from '../text_truncate';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { euiTableCellContentStyles } from './_table_cell_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableCellContent = function EuiTableCellContent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    textOnly = _ref.textOnly,
    _ref$truncateText = _ref.truncateText,
    truncateText = _ref$truncateText === void 0 ? false : _ref$truncateText,
    hasActions = _ref.hasActions,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useEuiTableIsResponsive();
  var styles = useEuiMemoizedStyles(euiTableCellContentStyles);
  var cssStyles = [styles.euiTableCellContent, styles[align], truncateText === true && styles.truncateText, truncateText === false && styles.wrapText].concat(_toConsumableArray(hasActions ? [styles.hasActions.actions, !isResponsive && styles.hasActions.desktop, isResponsive && hasActions !== 'custom' && styles.hasActions.mobile] : []));
  var classes = classNames('euiTableCellContent', className);
  var renderedChildren = useMemo(function () {
    var textClasses = 'euiTableCellContent__text';
    if (isObject(truncateText) && truncateText.lines) {
      return ___EmotionJSX(EuiTextBlockTruncate, {
        lines: truncateText.lines,
        cloneElement: true
      }, ___EmotionJSX("span", {
        className: textClasses
      }, children));
    }
    if (textOnly === true || truncateText === true) {
      return ___EmotionJSX("span", {
        className: textClasses
      }, children);
    }
    return children;
  }, [children, textOnly, truncateText]);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), renderedChildren);
};