/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { createContext, useContext } from 'react';
import { useIsWithinMinBreakpoint } from '../../../services';
import { useComponentDefaults } from '../../provider/component_defaults';
export var DEFAULT_TABLE_BREAKPOINT = 'm';

/**
 * Used by parent/top-level table components to determine isResponsive state
 * based on the passed breakpoint
 */
export var useIsEuiTableResponsive = function useIsEuiTableResponsive(componentProp) {
  var _useComponentDefaults, _ref;
  var componentDefault = (_useComponentDefaults = useComponentDefaults().EuiTable) === null || _useComponentDefaults === void 0 ? void 0 : _useComponentDefaults.responsiveBreakpoint;
  var breakpoint = (_ref = componentProp !== null && componentProp !== void 0 ? componentProp : componentDefault) !== null && _ref !== void 0 ? _ref : DEFAULT_TABLE_BREAKPOINT;
  var isBoolean = typeof breakpoint === 'boolean';

  // Note: we're using `!useIsWithinMinBreakpoint` here instead of `useIsWithinMaxBreakpoint`
  // because it more accurately reflects the single breakpoint at which tables collapse
  var isResponsive = !useIsWithinMinBreakpoint(isBoolean ? '' : breakpoint);
  return isBoolean ? breakpoint : isResponsive;
};

/**
 * Context set by parent table components
 * Hook used by cells to fetch parent isResponsive state
 */
export var EuiTableIsResponsiveContext = /*#__PURE__*/createContext(false);
export var useEuiTableIsResponsive = function useEuiTableIsResponsive() {
  return useContext(EuiTableIsResponsiveContext);
};