import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "anchorPosition", "items"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { EuiButtonEmpty } from '../../button/button_empty';
import { EuiPopover } from '../../popover';
import { EuiContextMenuPanel } from '../../context_menu';
import { EuiI18n } from '../../i18n';
import { EuiTableSortMobileItem } from './table_sort_mobile_item';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableSortMobile = /*#__PURE__*/function (_Component) {
  function EuiTableSortMobile() {
    var _this;
    _classCallCheck(this, EuiTableSortMobile);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiTableSortMobile, [].concat(args));
    _defineProperty(_this, "state", {
      isPopoverOpen: false
    });
    _defineProperty(_this, "onButtonClick", function () {
      _this.setState({
        isPopoverOpen: !_this.state.isPopoverOpen
      });
    });
    _defineProperty(_this, "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });
    // Aligns the button to the right even when it's the only element present
    _defineProperty(_this, "euiTableSortMobileStyles", {
      marginInlineStart: 'auto',
      label: 'euiTableSortMobile'
    });
    return _this;
  }
  _inherits(EuiTableSortMobile, _Component);
  return _createClass(EuiTableSortMobile, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        className = _this$props.className,
        anchorPosition = _this$props.anchorPosition,
        items = _this$props.items,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var classes = classNames('euiTableSortMobile', className);
      var mobileSortButton = ___EmotionJSX(EuiButtonEmpty, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.onButtonClick.bind(this),
        flush: "right",
        size: "xs"
      }, ___EmotionJSX(EuiI18n, {
        token: "euiTableSortMobile.sorting",
        default: "Sorting"
      }));
      var mobileSortPopover = ___EmotionJSX(EuiPopover, _extends({
        button: mobileSortButton,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        anchorPosition: anchorPosition || 'downRight',
        panelPaddingSize: "none"
      }, rest), ___EmotionJSX(EuiContextMenuPanel, {
        style: {
          minWidth: 200
        },
        items: items && items.length ? items.map(function (item) {
          return ___EmotionJSX(EuiTableSortMobileItem, {
            key: item.key,
            onSort: item.onSort,
            isSorted: item.isSorted,
            isSortAscending: item.isSortAscending
          }, item.name);
        }) : undefined
      }));
      return ___EmotionJSX("div", {
        className: classes,
        css: this.euiTableSortMobileStyles
      }, mobileSortPopover);
    }
  }]);
}(Component);