import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "compressed", "tableLayout", "responsiveBreakpoint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useIsEuiTableResponsive, EuiTableIsResponsiveContext } from './mobile/responsive_context';
import { euiTableStyles } from './table.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTable = function EuiTable(_ref) {
  var children = _ref.children,
    className = _ref.className,
    compressed = _ref.compressed,
    _ref$tableLayout = _ref.tableLayout,
    tableLayout = _ref$tableLayout === void 0 ? 'fixed' : _ref$tableLayout,
    responsiveBreakpoint = _ref.responsiveBreakpoint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useIsEuiTableResponsive(responsiveBreakpoint);
  var classes = classNames('euiTable', className);
  var styles = useEuiMemoizedStyles(euiTableStyles);
  var cssStyles = [styles.euiTable, styles.layout[tableLayout], (!compressed || isResponsive) && styles.uncompressed, compressed && !isResponsive && styles.compressed, isResponsive ? styles.mobile : styles.desktop];
  return ___EmotionJSX("table", _extends({
    tabIndex: -1,
    css: cssStyles,
    className: classes
  }, rest), ___EmotionJSX(EuiTableIsResponsiveContext.Provider, {
    value: isResponsive
  }, children));
};