import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { makeHighContrastColor, tintOrShade } from '../../services';
import { euiFontSize, logicalCSS, logicalTextAlignCSS } from '../../global_styling';
import { euiTableVariables } from './table.styles';
export var euiTableHeaderFooterCellStyles = function euiTableHeaderFooterCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;

  // euiFontSize returns an object, so we keep object notation here to merge into css``
  var sharedStyles = _objectSpread(_objectSpread({}, euiFontSize(euiThemeContext, 'xs')), {}, {
    fontWeight: euiTheme.font.weight.semiBold,
    color: euiTheme.colors.title,
    verticalAlign: 'middle'
  });
  return {
    euiTableHeaderCell: /*#__PURE__*/css(sharedStyles, ";;label:euiTableHeaderCell;"),
    euiTableHeaderCell__content: /*#__PURE__*/css("gap:", euiTheme.size.xs, ";;label:euiTableHeaderCell__content;"),
    euiTableHeaderCell__button: /*#__PURE__*/css(logicalCSS('width', '100%'), " font-weight:inherit;line-height:inherit;.euiTableSortIcon--sortable{color:", makeHighContrastColor(
    // Tint it arbitrarily high, the contrast util will take care of lowering back down to WCAG
    tintOrShade(euiTheme.colors.subduedText, 0.9, colorMode), 3 // 3:1 ratio from https://www.w3.org/WAI/WCAG22/Understanding/non-text-contrast.html
    )(euiTheme.colors.emptyShade), ";}&:hover,&:focus{color:", euiTheme.colors.primaryText, ";text-decoration:underline;.euiTableSortIcon--sortable{color:", euiTheme.colors.primaryText, ";}};label:euiTableHeaderCell__button;"),
    euiTableFooterCell: /*#__PURE__*/css(sharedStyles, " background-color:", euiTheme.colors.lightestShade, ";;label:euiTableFooterCell;")
  };
};
export var euiTableCellCheckboxStyles = function euiTableCellCheckboxStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiTableVariables = euiTableVariables(euiThemeContext),
    cellContentPadding = _euiTableVariables.cellContentPadding,
    mobileSizes = _euiTableVariables.mobileSizes,
    checkboxSize = _euiTableVariables.checkboxSize;
  var sharedCheckboxStyles = "\n    ".concat(logicalCSS('width', checkboxSize), "\n    vertical-align: middle;\n  ");
  return {
    euiTableHeaderCellCheckbox: /*#__PURE__*/css(sharedCheckboxStyles, logicalTextAlignCSS('left'), ";;label:euiTableHeaderCellCheckbox;"),
    euiTableRowCellCheckbox: /*#__PURE__*/css(sharedCheckboxStyles, ";;label:euiTableRowCellCheckbox;"),
    desktop: /*#__PURE__*/css(logicalCSS('border-vertical', euiTheme.border.thin), ";;label:desktop;"),
    mobile: /*#__PURE__*/css("position:absolute;", logicalCSS('top', cellContentPadding), " ", logicalCSS('left', mobileSizes.checkbox.offset), ";;label:mobile;")
  };
};