import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "align", "className", "width", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, LEFT_ALIGNMENT } from '../../services';
import { resolveWidthAsStyle } from './utils';
import { EuiTableCellContent } from './_table_cell_content';
import { euiTableHeaderFooterCellStyles } from './table_cells_shared.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableFooterCell = function EuiTableFooterCell(_ref) {
  var children = _ref.children,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    className = _ref.className,
    width = _ref.width,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTableFooterCell', className);
  var inlineStyles = resolveWidthAsStyle(style, width);
  var styles = useEuiMemoizedStyles(euiTableHeaderFooterCellStyles);
  return ___EmotionJSX("td", _extends({
    css: styles.euiTableFooterCell,
    className: classes,
    style: inlineStyles
  }, rest), ___EmotionJSX(EuiTableCellContent, {
    align: align,
    truncateText: true,
    textOnly: true
  }, children));
};