import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "scope", "style", "width", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { resolveWidthAsStyle } from './utils';
import { euiTableCellCheckboxStyles } from './table_cells_shared.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableHeaderCellCheckbox = function EuiTableHeaderCellCheckbox(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$scope = _ref.scope,
    scope = _ref$scope === void 0 ? 'col' : _ref$scope,
    style = _ref.style,
    width = _ref.width,
    append = _ref.append,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTableHeaderCellCheckbox', className);
  var styles = useEuiMemoizedStyles(euiTableCellCheckboxStyles);
  var inlineStyles = resolveWidthAsStyle(style, width);
  return ___EmotionJSX("th", _extends({
    css: styles.euiTableHeaderCellCheckbox,
    className: classes,
    scope: scope,
    style: inlineStyles
  }, rest), ___EmotionJSX("div", {
    className: "euiTableCellContent"
  }, children), append);
};