import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, useCallback } from 'react';
import { EuiButtonEmpty } from '../../button';
import { EuiContextMenuItem, EuiContextMenuPanel } from '../../context_menu';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPagination } from '../../pagination';
import { EuiPopover } from '../../popover';
import { EuiI18n } from '../../i18n';
import { usePropsWithComponentDefaults } from '../../provider/component_defaults';
import { euiTablePaginationDefaults } from './table_pagination_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTablePagination = function EuiTablePagination(props) {
  var _usePropsWithComponen = usePropsWithComponentDefaults('EuiTablePagination', props),
    activePage = _usePropsWithComponen.activePage,
    _usePropsWithComponen2 = _usePropsWithComponen.itemsPerPage,
    itemsPerPage = _usePropsWithComponen2 === void 0 ? euiTablePaginationDefaults.itemsPerPage : _usePropsWithComponen2,
    _usePropsWithComponen3 = _usePropsWithComponen.itemsPerPageOptions,
    itemsPerPageOptions = _usePropsWithComponen3 === void 0 ? euiTablePaginationDefaults.itemsPerPageOptions : _usePropsWithComponen3,
    _usePropsWithComponen4 = _usePropsWithComponen.showPerPageOptions,
    showPerPageOptions = _usePropsWithComponen4 === void 0 ? euiTablePaginationDefaults.showPerPageOptions : _usePropsWithComponen4,
    onChangeItemsPerPage = _usePropsWithComponen.onChangeItemsPerPage,
    onChangePage = _usePropsWithComponen.onChangePage,
    pageCount = _usePropsWithComponen.pageCount,
    rest = _objectWithoutProperties(_usePropsWithComponen, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = useCallback(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = useCallback(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = ___EmotionJSX(EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = useMemo(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return ___EmotionJSX(EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        "aria-current": itemsPerPageOption === itemsPerPage ? 'true' : undefined,
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage === null || onChangeItemsPerPage === void 0 || onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = ___EmotionJSX(EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, ___EmotionJSX(EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "tablePaginationRowOptions"
  }));
  return ___EmotionJSX(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && ___EmotionJSX(EuiPagination, _extends({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};