import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["align", "children", "className", "truncateText", "setScopeRow", "textOnly", "hasActions", "isExpander", "style", "width", "valign", "mobileOptions", "append"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, LEFT_ALIGNMENT } from '../../services';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { resolveWidthAsStyle } from './utils';
import { EuiTableCellContent } from './_table_cell_content';
import { euiTableRowCellStyles } from './table_row_cell.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableRowCell = function EuiTableRowCell(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    children = _ref.children,
    className = _ref.className,
    truncateText = _ref.truncateText,
    setScopeRow = _ref.setScopeRow,
    _ref$textOnly = _ref.textOnly,
    textOnly = _ref$textOnly === void 0 ? true : _ref$textOnly,
    hasActions = _ref.hasActions,
    isExpander = _ref.isExpander,
    style = _ref.style,
    width = _ref.width,
    _ref$valign = _ref.valign,
    valign = _ref$valign === void 0 ? 'middle' : _ref$valign,
    mobileOptions = _ref.mobileOptions,
    append = _ref.append,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useEuiTableIsResponsive();
  var styles = useEuiMemoizedStyles(euiTableRowCellStyles);
  var cssStyles = [styles.euiTableRowCell, setScopeRow && styles.rowHeader, isExpander && styles.isExpander, hasActions && styles.hasActions, styles[valign]].concat(_toConsumableArray(isResponsive ? [styles.mobile.mobile, (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.enlarge) && styles.mobile.enlarge, hasActions === 'custom' && styles.mobile.customActions, hasActions === true && styles.mobile.actions, isExpander && styles.mobile.expander] : [styles.desktop.desktop, hasActions && styles.desktop.actions]));
  var cellClasses = classNames('euiTableRowCell', className, {
    'euiTableRowCell--hasActions': hasActions,
    'euiTableRowCell--isExpander': isExpander
  });
  var widthValue = isResponsive ? hasActions || isExpander ? undefined // On mobile, actions are shifted to a right column via CSS
  : mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.width : width;
  var styleObj = resolveWidthAsStyle(style, widthValue);
  var Element = setScopeRow ? 'th' : 'td';
  var sharedProps = _objectSpread({
    scope: setScopeRow ? 'row' : undefined,
    style: styleObj,
    css: cssStyles
  }, rest);
  var sharedContentProps = {
    align: align,
    textOnly: textOnly,
    truncateText: truncateText,
    hasActions: hasActions || isExpander
  };
  if (isResponsive) {
    // Mobile view
    if ((mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false) {
      return null;
    } else {
      var _mobileOptions$align, _mobileOptions$trunca, _mobileOptions$textOn;
      return ___EmotionJSX(Element, _extends({
        className: cellClasses
      }, sharedProps), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.header) && ___EmotionJSX("div", {
        className: "euiTableRowCell__mobileHeader",
        css: styles.euiTableRowCell__mobileHeader
      }, mobileOptions.header), ___EmotionJSX(EuiTableCellContent, _extends({}, sharedContentProps, {
        align: (_mobileOptions$align = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.align) !== null && _mobileOptions$align !== void 0 ? _mobileOptions$align : 'left' // Default to left aligned mobile cells, unless consumers specifically set an alignment for mobile
        ,
        truncateText: (_mobileOptions$trunca = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.truncateText) !== null && _mobileOptions$trunca !== void 0 ? _mobileOptions$trunca : truncateText,
        textOnly: (_mobileOptions$textOn = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.textOnly) !== null && _mobileOptions$textOn !== void 0 ? _mobileOptions$textOn : textOnly
      }), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.render) || children), append);
    }
  } else {
    // Desktop view
    if (mobileOptions !== null && mobileOptions !== void 0 && mobileOptions.only) {
      return null;
    } else {
      return ___EmotionJSX(Element, _extends({
        className: cellClasses
      }, sharedProps), ___EmotionJSX(EuiTableCellContent, sharedContentProps, children), append);
    }
  }
};