import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { euiTableCellCheckboxStyles } from './table_cells_shared.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableRowCellCheckbox = function EuiTableRowCellCheckbox(_ref) {
  var children = _ref.children,
    className = _ref.className,
    append = _ref.append,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useEuiTableIsResponsive();
  var styles = useEuiMemoizedStyles(euiTableCellCheckboxStyles);
  var cssStyles = [styles.euiTableRowCellCheckbox, isResponsive ? styles.mobile : styles.desktop];
  var classes = classNames('euiTableRowCellCheckbox', className);
  return ___EmotionJSX("td", _extends({
    css: cssStyles,
    className: classes
  }, rest), ___EmotionJSX("div", {
    className: "euiTableCellContent"
  }, children), append);
};