import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isSelected", "children", "className", "disabled", "href", "target", "rel", "prepend", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiMemoizedStyles } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { euiTabStyles, euiTabContentStyles } from './tab.styles';
import { EuiTabsContext } from './tabs_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTab = function EuiTab(_ref) {
  var isSelected = _ref.isSelected,
    children = _ref.children,
    className = _ref.className,
    _disabled = _ref.disabled,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    prepend = _ref.prepend,
    append = _ref.append,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiTabsContext),
    size = _useContext.size,
    expand = _useContext.expand;
  var isHrefValid = !href || validateHref(href);
  var disabled = _disabled || !isHrefValid;

  // Keep CSS classnames for reference
  var classes = classNames('euiTab', className, {
    'euiTab-isSelected': isSelected
  });
  var tabStyles = useEuiMemoizedStyles(euiTabStyles);
  var cssTabStyles = [tabStyles.euiTab, expand && tabStyles.expanded, disabled && tabStyles.disabled.disabled, isSelected && (disabled ? tabStyles.disabled.selected : tabStyles.selected)];
  var tabContentStyles = useEuiMemoizedStyles(euiTabContentStyles);
  var cssTabContentStyles = [tabContentStyles.euiTab__content, size && tabContentStyles[size]];
  var prependNode = prepend && ___EmotionJSX("span", {
    className: "euiTab__prepend"
  }, prepend);
  var appendNode = append && ___EmotionJSX("span", {
    className: "euiTab__append"
  }, append);

  //  <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  //  this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    return ___EmotionJSX("a", _extends({
      role: "tab",
      "aria-selected": !!isSelected,
      tabIndex: isSelected ? 0 : -1,
      className: classes,
      css: cssTabStyles,
      href: href,
      target: target,
      rel: secureRel
    }, rest), prependNode, ___EmotionJSX("span", {
      className: "euiTab__content eui-textTruncate",
      css: cssTabContentStyles
    }, children), appendNode);
  }
  return ___EmotionJSX("button", _extends({
    role: "tab",
    "aria-selected": !!isSelected,
    tabIndex: isSelected ? 0 : -1,
    type: "button",
    className: classes,
    css: cssTabStyles,
    disabled: disabled
  }, rest), prependNode, ___EmotionJSX("span", {
    className: "euiTab__content eui-textTruncate",
    css: cssTabContentStyles
  }, children), appendNode);
};