function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits, euiFontSize } from '../../global_styling';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;"
} : {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiTabStyles = function euiTabStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiTab: /*#__PURE__*/css("display:flex;cursor:pointer;flex-direction:row;align-items:center;gap:", euiTheme.size.s, ";", logicalCSS('padding-vertical', 0), " ", logicalCSS('padding-horizontal', euiTheme.size.xs), "font-weight:", euiTheme.font.weight.semiBold, ";color:", euiTheme.colors.title, ";&:focus{outline-offset:-", euiTheme.focus.width, ";};label:euiTab;"),
    // variations
    expanded: _ref,
    selected: /*#__PURE__*/css("box-shadow:inset 0 -", euiTheme.border.width.thick, " 0 ", euiTheme.colors.primary, ";color:", euiTheme.colors.primaryText, ";;label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/css("cursor:not-allowed;color:", euiTheme.colors.disabledText, ";;label:disabled;"),
      selected: /*#__PURE__*/css("box-shadow:inset 0 -", euiTheme.border.width.thick, " 0 ", euiTheme.colors.disabledText, ";;label:selected;")
    }
  };
};
export var euiTabContentStyles = function euiTabContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiTab__content: /*#__PURE__*/css("font-weight:", euiTheme.font.weight[euiTheme.font.title.weight], ";;label:euiTab__content;"),
    // sizes
    s: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";line-height:", euiTheme.size.xl, ";;label:s;"),
    m: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 's').fontSize, ";line-height:", euiTheme.size.xxl, ";;label:m;"),
    l: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'm').fontSize, ";line-height:", mathWithUnits([euiTheme.size.xl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:l;"),
    xl: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'l').fontSize, ";line-height:", mathWithUnits([euiTheme.size.xxxl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:xl;")
  };
};