import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "expand", "initialSelectedTab", "onTabClick", "selectedTab", "size", "tabs", "autoFocus"],
  _excluded2 = ["id", "name", "content"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import { htmlIdGenerator } from '../../../services';
import { EuiTabs } from '../tabs';
import { EuiTab } from '../tab';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Marked as const so type is `['initial', 'selected']` instead of `string[]`
 */
export var AUTOFOCUS = ['initial', 'selected'];
export var EuiTabbedContent = /*#__PURE__*/function (_Component) {
  function EuiTabbedContent(props) {
    var _this;
    _classCallCheck(this, EuiTabbedContent);
    _this = _callSuper(this, EuiTabbedContent, [props]);
    _defineProperty(_this, "rootId", htmlIdGenerator()());
    _defineProperty(_this, "tabsRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "focusTab", function () {
      var targetTab = _this.tabsRef.current.querySelector("#".concat(_this.state.selectedTabId));
      targetTab.focus();
    });
    _defineProperty(_this, "initializeFocus", function () {
      if (!_this.state.inFocus && _this.props.autoFocus === 'selected') {
        // Must wait for setState to finish before calling `.focus()`
        // as the focus call triggers a blur on the first tab
        _this.setState({
          inFocus: true
        }, function () {
          _this.focusTab();
        });
      }
    });
    _defineProperty(_this, "removeFocus", function (blurEvent) {
      // only set inFocus to false if the wrapping div doesn't contain the now-focusing element
      var currentTarget = blurEvent.currentTarget;
      var relatedTarget = blurEvent.relatedTarget;
      if (currentTarget.contains(relatedTarget) === false) {
        _this.setState({
          inFocus: false
        });
      }
    });
    _defineProperty(_this, "onTabClick", function (selectedTab) {
      var _this$props = _this.props,
        onTabClick = _this$props.onTabClick,
        externalSelectedTab = _this$props.selectedTab;
      if (onTabClick) {
        onTabClick(selectedTab);
      }

      // Only track selection state if it's not controlled externally.
      if (!externalSelectedTab) {
        _this.setState({
          selectedTabId: selectedTab.id
        }, function () {
          _this.focusTab();
        });
      }
    });
    var initialSelectedTab = props.initialSelectedTab,
      _selectedTab = props.selectedTab,
      tabs = props.tabs;

    // Only track selection state if it's not controlled externally.
    var selectedTabId;
    if (!_selectedTab) {
      selectedTabId = (initialSelectedTab === null || initialSelectedTab === void 0 ? void 0 : initialSelectedTab.id) || tabs[0].id;
    }
    _this.state = {
      selectedTabId: selectedTabId,
      inFocus: false
    };
    return _this;
  }
  _inherits(EuiTabbedContent, _Component);
  return _createClass(EuiTabbedContent, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        className = _this$props2.className,
        expand = _this$props2.expand,
        initialSelectedTab = _this$props2.initialSelectedTab,
        onTabClick = _this$props2.onTabClick,
        externalSelectedTab = _this$props2.selectedTab,
        size = _this$props2.size,
        tabs = _this$props2.tabs,
        autoFocus = _this$props2.autoFocus,
        rest = _objectWithoutProperties(_this$props2, _excluded);

      // Allow the consumer to control tab selection.
      var selectedTab = externalSelectedTab || tabs.find(function (tab) {
        return tab.id === _this2.state.selectedTabId;
      }) || tabs[0]; // Fall back to the first tab if a selected tab can't be found

      var selectedTabContent = selectedTab.content,
        selectedTabId = selectedTab.id;
      return ___EmotionJSX("div", _extends({
        className: className
      }, rest), ___EmotionJSX(EuiTabs, {
        ref: this.tabsRef,
        expand: expand,
        size: size,
        onFocus: this.initializeFocus,
        onBlur: this.removeFocus
      }, tabs.map(function (tab) {
        var id = tab.id,
          name = tab.name,
          content = tab.content,
          tabProps = _objectWithoutProperties(tab, _excluded2);
        var props = _objectSpread(_objectSpread({
          key: id,
          id: id
        }, tabProps), {}, {
          onClick: function onClick() {
            return _this2.onTabClick(tab);
          },
          isSelected: tab === selectedTab,
          'aria-controls': "".concat(_this2.rootId)
        });
        return ___EmotionJSX(EuiTab, props, name);
      })), ___EmotionJSX("div", {
        role: "tabpanel",
        id: "".concat(this.rootId),
        "aria-labelledby": selectedTabId
      }, selectedTabContent));
    }
  }]);
}(Component);
_defineProperty(EuiTabbedContent, "defaultProps", {
  autoFocus: 'initial'
});