import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "bottomBorder", "expand", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import classNames from 'classnames';
import { keys, useEuiMemoizedStyles } from '../../services';
import { euiTabsStyles } from './tabs.styles';
import { EuiTabsContext } from './tabs_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['s', 'm', 'l', 'xl'];
export var EuiTabs = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$bottomBorder = _ref.bottomBorder,
    bottomBorder = _ref$bottomBorder === void 0 ? true : _ref$bottomBorder,
    _ref$expand = _ref.expand,
    expand = _ref$expand === void 0 ? false : _ref$expand,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTabs', className);
  var styles = useEuiMemoizedStyles(euiTabsStyles);
  var cssStyles = [styles.euiTabs, styles[size], bottomBorder && styles.bottomBorder];
  var handleKeyDown = function handleKeyDown(event) {
    var tablist = event.currentTarget;
    var tabs = tablist === null || tablist === void 0 ? void 0 : tablist.querySelectorAll('[role="tab"]:not(:disabled, [inert])');
    if (!(tabs !== null && tabs !== void 0 && tabs.length)) return;
    var currentIndex = Array.from(tabs).findIndex(function (tab) {
      return tab.matches(':focus');
    });
    if (event.key === keys.ARROW_LEFT) {
      var previousIndex = (currentIndex === 0 ? tabs.length : currentIndex) - 1;
      tabs[previousIndex].focus();
    } else if (event.key === keys.ARROW_RIGHT) {
      var nextIndex = currentIndex === tabs.length - 1 ? 0 : currentIndex + 1;
      tabs[nextIndex].focus();
    }
  };
  return ___EmotionJSX("div", _extends({
    ref: ref,
    className: classes,
    css: cssStyles,
    onKeyDown: handleKeyDown
  }, children && {
    role: 'tablist'
  }, rest), ___EmotionJSX(EuiTabsContext.Provider, {
    value: {
      expand: expand,
      size: size
    }
  }, children));
});
EuiTabs.displayName = 'EuiTabs';