/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalCSSWithFallback } from '../../global_styling';
export var euiTabsStyles = function euiTabsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiTabs: /*#__PURE__*/css("display:flex;", logicalCSS('max-width', '100%'), " ", logicalCSSWithFallback('overflow-x', 'auto'), " ", logicalCSSWithFallback('overflow-y', 'hidden'), " position:relative;flex-shrink:0;;label:euiTabs;"),
    bottomBorder: /*#__PURE__*/css("box-shadow:inset 0 -", euiTheme.border.width.thin, " 0 ", euiTheme.border.color, ";;label:bottomBorder;"),
    // sizes
    s: /*#__PURE__*/css("gap:", euiTheme.size.m, ";;label:s;"),
    m: /*#__PURE__*/css("gap:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/css("gap:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/css("gap:", euiTheme.size.xl, ";;label:xl;")
  };
};