import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "component", "textAlign", "cloneElement"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement } from 'react';
import { cloneElementWithCss } from '../../services';
import { euiTextAlignStyles as styles } from './text_align.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGNMENTS = ['left', 'right', 'center'];
export var EuiTextAlign = function EuiTextAlign(_ref) {
  var children = _ref.children,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
    _ref$cloneElement = _ref.cloneElement,
    cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
    rest = _objectWithoutProperties(_ref, _excluded);
  var cssStyles = [styles.euiTextAlign, styles[textAlign]];
  var props = _objectSpread({
    css: cssStyles
  }, rest);
  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    return cloneElementWithCss(children, props);
  } else {
    return ___EmotionJSX(Component, props, children);
  }
};