import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "color", "component", "cloneElement", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement } from 'react';
import { useEuiMemoizedStyles, cloneElementWithCss } from '../../services';
import { euiTextColorStyles } from './text_color.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['default', 'subdued', 'success', 'accent', 'danger', 'warning', 'ghost', 'inherit'];
export var _isNamedColor = function _isNamedColor(color) {
  return COLORS.includes(color);
};
export var EuiTextColor = function EuiTextColor(_ref) {
  var children = _ref.children,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'span' : _ref$component,
    _ref$cloneElement = _ref.cloneElement,
    cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isNamedColor = _isNamedColor(color);
  var styles = useEuiMemoizedStyles(euiTextColorStyles);
  var cssStyles = [styles.euiTextColor, isNamedColor ? styles[color] : styles.customColor];

  // We're checking if is a custom color.
  // If it is a custom color we set the `color` of the `.euiTextColor` div to that custom color.
  // This way the children text elements can `inherit` that color and border and backgrounds can get that `currentColor`.
  var euiTextStyle = !isNamedColor ? _objectSpread({
    color: color
  }, style) : _objectSpread({}, style);
  var props = _objectSpread({
    css: cssStyles,
    style: euiTextStyle
  }, rest);
  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    var childrenStyle = _objectSpread(_objectSpread({}, children.props.style), euiTextStyle);
    return cloneElementWithCss(children, _objectSpread(_objectSpread({}, props), {}, {
      style: childrenStyle
    }));
  } else {
    return ___EmotionJSX(Component, props, children);
  }
};