import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "style", "lines", "cloneElement"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement, useMemo } from 'react';
import { css } from '@emotion/react';
import classNames from 'classnames';
import { cloneElementWithCss } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var styles = {
  euiTextBlockTruncate: process.env.NODE_ENV === "production" ? {
    name: "1cfm3ge-euiTextBlockTruncate",
    styles: "display:-webkit-box;-webkit-box-orient:vertical;-webkit-line-clamp:0;overflow:hidden;label:euiTextBlockTruncate;"
  } : {
    name: "1cfm3ge-euiTextBlockTruncate",
    styles: "display:-webkit-box;-webkit-box-orient:vertical;-webkit-line-clamp:0;overflow:hidden;label:euiTextBlockTruncate;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
export var EuiTextBlockTruncate = function EuiTextBlockTruncate(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    lines = _ref.lines,
    cloneElement = _ref.cloneElement,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTextBlockTruncate', className);
  var cssStyles = styles.euiTextBlockTruncate;
  var inlineStyles = useMemo(function () {
    return _objectSpread({
      WebkitLineClamp: lines
    }, style);
  }, [lines, style]);
  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    return cloneElementWithCss(children, {
      css: cssStyles,
      style: _objectSpread(_objectSpread({}, children.props.style), inlineStyles),
      className: classNames(children.props.className, classes)
    });
  } else {
    return ___EmotionJSX("div", _extends({
      className: classes,
      css: cssStyles,
      style: inlineStyles
    }, rest), children);
  }
};