/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
var _gutterSizeAdjustment = function _gutterSizeAdjustment(gutterSize) {
  return "\n    gap: ".concat(gutterSize, ";\n\n    // The vertical line height needs to be adjusted with the gutter size\n    [class*='euiTimelineItem-']:not(:last-child) > [class*='euiTimelineItemIcon-']::before {\n      ").concat(logicalCSS('height', "calc(100% + ".concat(gutterSize, ")")), ";\n    }\n  ");
};

// The vertical line should only appear when the EuiTimelineItem's
// are wrapped in a EuiTimeline. That's why these styles live here.
var timelineVerticalLine = function timelineVerticalLine(euiTheme) {
  return "  \n    [class*='euiTimelineItem-'] > [class*='euiTimelineItemIcon-']::before {\n      content: '';\n      position: absolute;\n      ".concat(logicalCSS('top', 0), ";\n      ").concat(logicalCSS('width', euiTheme.size.xxs), ";\n      background-color: ").concat(euiTheme.colors.lightShade, ";\n    }\n\n    > [class*='euiTimelineItem-center']:first-child > [class*='euiTimelineItemIcon-']::before {\n      ").concat(logicalCSS('top', '50%'), ";\n    }\n  \n    > [class*='euiTimelineItem-center']:last-child:not(:only-child) > [class*='euiTimelineItemIcon-']::before {\n      ").concat(logicalCSS('height', '50%'), ";\n    }\n  ");
};
export var euiTimelineStyles = function euiTimelineStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiTimeline: /*#__PURE__*/css("display:flex;flex-direction:column;", timelineVerticalLine(euiTheme), ";;label:euiTimeline;"),
    m: /*#__PURE__*/css(_gutterSizeAdjustment(euiTheme.size.base), ";label:m;"),
    l: /*#__PURE__*/css(_gutterSizeAdjustment(euiTheme.size.l), ";label:l;"),
    xl: /*#__PURE__*/css(_gutterSizeAdjustment(euiTheme.size.xl), ";label:xl;")
  };
};