import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiTimelineItemEvent } from './timeline_item_event';
import { EuiTimelineItemIcon } from './timeline_item_icon';
import { euiTimelineItemStyles } from './timeline_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var VERTICAL_ALIGN = ['top', 'center'];
export var EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
    _ref$verticalAlign = _ref.verticalAlign,
    verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
    icon = _ref.icon,
    iconAriaLabel = _ref.iconAriaLabel,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = euiTimelineItemStyles();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return ___EmotionJSX("li", _extends({
    css: cssStyles
  }, rest), ___EmotionJSX(EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), ___EmotionJSX(EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};