import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "toasts", "dismissToast", "toastLifeTimeMs", "onClearAllToasts", "side", "showClearAllButtonAt"],
  _excluded2 = ["text", "toastLifeTimeMs"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useEffect, useMemo, useRef, useState } from 'react';
import classNames from 'classnames';
import { keysOf } from '../common';
import { useEuiMemoizedStyles } from '../../services';
import { Timer } from '../../services/time';
import { EuiGlobalToastListItem } from './global_toast_list_item';
import { EuiToast } from './toast';
import { euiGlobalToastListStyles } from './global_toast_list.styles';
import { EuiButton } from '../button';
import { EuiI18n } from '../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
var sideToClassNameMap = {
  left: 'euiGlobalToastList--left',
  right: 'euiGlobalToastList--right'
};
export var SIDES = keysOf(sideToClassNameMap);
export var TOAST_FADE_OUT_MS = 250;
export var CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT = 3;
export var EuiGlobalToastList = function EuiGlobalToastList(_ref) {
  var className = _ref.className,
    _ref$toasts = _ref.toasts,
    toasts = _ref$toasts === void 0 ? [] : _ref$toasts,
    dismissToastProp = _ref.dismissToast,
    toastLifeTimeMs = _ref.toastLifeTimeMs,
    onClearAllToasts = _ref.onClearAllToasts,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$showClearAllButt = _ref.showClearAllButtonAt,
    showClearAllButtonAt = _ref$showClearAllButt === void 0 ? CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT : _ref$showClearAllButt,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    toastIdToDismissedMap = _useState2[0],
    setToastIdToDismissedMap = _useState2[1];
  var _useState3 = useState(),
    _useState4 = _slicedToArray(_useState3, 2),
    toastToDismiss = _useState4[0],
    setToastToDismiss = _useState4[1];
  var prevToasts = useRef([]);
  var dismissTimeoutIds = useRef([]);
  var toastIdToTimerMap = useRef({});
  var isScrollingToBottom = useRef(false);
  var isScrolledToBottom = useRef(true);
  var isUserInteracting = useRef(false);

  // See [Return Value](https://developer.mozilla.org/en-US/docs/Web/API/Window/requestAnimationFrame#Return_value)
  // for information on initial value of 0
  var isScrollingAnimationFrame = useRef(0);
  var startScrollingAnimationFrame = useRef(0);
  var listElement = useRef(null);
  var styles = useEuiMemoizedStyles(euiGlobalToastListStyles);
  var cssStyles = [styles.euiGlobalToastList, styles[side]];
  var startScrollingToBottom = useCallback(function () {
    isScrollingToBottom.current = true;
    var scrollToBottom = function scrollToBottom() {
      // Although we cancel the requestAnimationFrame in componentWillUnmount,
      // it's possible for this.listElement to become null in the meantime
      if (!listElement.current) {
        return;
      }
      var position = listElement.current.scrollTop;
      var destination = listElement.current.scrollHeight - listElement.current.clientHeight;
      var distanceToDestination = destination - position;
      if (distanceToDestination < 5) {
        listElement.current.scrollTop = destination;
        isScrollingToBottom.current = false;
        isScrolledToBottom.current = true;
        return;
      }
      listElement.current.scrollTop = position + distanceToDestination * 0.25;
      if (isScrollingToBottom) {
        isScrollingAnimationFrame.current = window.requestAnimationFrame(scrollToBottom);
      }
    };
    startScrollingAnimationFrame.current = window.requestAnimationFrame(scrollToBottom);
  }, []);
  var onMouseEnter = useCallback(function () {
    // Stop scrolling to bottom if we're in mid-scroll, because the user wants to interact with
    // the list.
    isScrollingToBottom.current = false;
    isUserInteracting.current = true;

    // Don't let toasts dismiss themselves while the user is interacting with them.
    for (var _toastId in toastIdToTimerMap.current) {
      if (toastIdToTimerMap.current.hasOwnProperty(_toastId)) {
        var timer = toastIdToTimerMap.current[_toastId];
        timer.pause();
      }
    }
  }, []);
  var onMouseLeave = useCallback(function () {
    isUserInteracting.current = false;
    for (var _toastId2 in toastIdToTimerMap.current) {
      if (toastIdToTimerMap.current.hasOwnProperty(_toastId2)) {
        var timer = toastIdToTimerMap.current[_toastId2];
        timer.resume();
      }
    }
  }, []);
  var onScroll = useCallback(function () {
    // Given that this method also gets invoked by the synthetic scroll that happens when a new toast gets added,
    // we want to evaluate if the scroll bottom has been reached only when the user is interacting with the toast,
    // this way we always retain the scroll position the user has set despite adding in new toasts.
    // User interaction is determined through the handler registered for mouseEnter and mouseLeave events.
    if (listElement.current && isUserInteracting.current) {
      isScrolledToBottom.current = listElement.current.scrollHeight - listElement.current.scrollTop === listElement.current.clientHeight;
    }
  }, []);
  var dismissToast = useCallback(function (toast) {
    // Remove the toast after it's done fading out.
    dismissTimeoutIds.current.push(window.setTimeout(function () {
      setToastToDismiss(toast);
    }, TOAST_FADE_OUT_MS));
    setToastIdToDismissedMap(function (prev) {
      return _objectSpread(_objectSpread({}, prev), {}, _defineProperty({}, toast.id, true));
    });
  }, []);
  var scheduleToastForDismissal = useCallback(function (toast) {
    // Start fading the toast out once its lifetime elapses.
    toastIdToTimerMap.current[toast.id] = new Timer(function () {
      return dismissToast(toast);
    }, toast.toastLifeTimeMs != null ? toast.toastLifeTimeMs : toastLifeTimeMs);
  }, [dismissToast, toastLifeTimeMs]);
  var scheduleAllToastsForDismissal = useCallback(function () {
    toasts.forEach(function (toast) {
      if (!toastIdToTimerMap.current[toast.id]) {
        scheduleToastForDismissal(toast);
      }
    });
  }, [scheduleToastForDismissal, toasts]);

  // componentDidMount
  useEffect(function () {
    var listenerEl = listElement.current;
    if (listenerEl) {
      listenerEl.addEventListener('scroll', onScroll);
      listenerEl.addEventListener('mouseenter', onMouseEnter);
      listenerEl.addEventListener('mouseleave', onMouseLeave);
    }

    // componentWillUnmount
    return function () {
      if (listenerEl) {
        listenerEl.removeEventListener('scroll', onScroll);
        listenerEl.removeEventListener('mouseenter', onMouseEnter);
        listenerEl.removeEventListener('mouseleave', onMouseLeave);
      }
      if (isScrollingAnimationFrame.current !== 0) {
        window.cancelAnimationFrame(isScrollingAnimationFrame.current);
      }
      if (startScrollingAnimationFrame.current !== 0) {
        window.cancelAnimationFrame(startScrollingAnimationFrame.current);
      }
      dismissTimeoutIds.current.forEach(clearTimeout); // eslint-disable-line react-hooks/exhaustive-deps
      for (var _toastId3 in toastIdToTimerMap.current) {
        if (toastIdToTimerMap.current.hasOwnProperty(_toastId3)) {
          var timer = toastIdToTimerMap.current[_toastId3]; // eslint-disable-line react-hooks/exhaustive-deps
          timer.clear();
        }
      }
    };
  }, [onMouseEnter, onMouseLeave, onScroll]);

  // componentDidUpdate
  useEffect(function () {
    scheduleAllToastsForDismissal();
    if (!isUserInteracting.current) {
      // If the user has scrolled up the toast list then we don't want to annoy them by scrolling
      // all the way back to the bottom.
      if (isScrolledToBottom.current) {
        if (prevToasts.current.length < toasts.length) {
          startScrollingToBottom();
        }
      }
    }
    prevToasts.current = toasts;
  }, [toasts, scheduleAllToastsForDismissal, startScrollingToBottom]);

  // Toast dismissal side effect
  // Ensure the callback has correct state by not enclosing it in `setTimeout`
  useEffect(function () {
    var toast = toastToDismiss;
    // Because this is triggered by a setTimeout, and because React does not guarantee when
    // state updates happen, it is possible to double-dismiss a toast
    // including by double-clicking the "x" button on the toast
    // so, first check to make sure we haven't already dismissed this toast
    if (toast && toastIdToTimerMap.current.hasOwnProperty(toast.id)) {
      dismissToastProp(toast);
      toastIdToTimerMap.current[toast.id].clear();
      delete toastIdToTimerMap.current[toast.id];
      setToastIdToDismissedMap(function (prev) {
        var toastIdToDismissedMap = _objectSpread({}, prev);
        delete toastIdToDismissedMap[toast.id];
        return toastIdToDismissedMap;
      });
    }
  }, [toastToDismiss, dismissToastProp]);
  var renderedToasts = useMemo(function () {
    return toasts.map(function (toast) {
      var text = toast.text,
        toastLifeTimeMs = toast.toastLifeTimeMs,
        rest = _objectWithoutProperties(toast, _excluded2);
      var onClose = function onClose() {
        return dismissToast(toast);
      };
      return ___EmotionJSX(EuiGlobalToastListItem, {
        key: toast.id,
        isDismissed: toastIdToDismissedMap[toast.id]
      }, ___EmotionJSX(EuiToast, _extends({
        onClose: onClose,
        onFocus: onMouseEnter,
        onBlur: onMouseLeave
      }, rest), text));
    });
  }, [toasts, toastIdToDismissedMap, dismissToast, onMouseEnter, onMouseLeave]);
  var clearAllButton = useMemo(function () {
    if (toasts.length && showClearAllButtonAt && toasts.length >= showClearAllButtonAt) {
      return ___EmotionJSX(EuiI18n, {
        key: "euiClearAllToasts",
        tokens: ['euiGlobalToastList.clearAllToastsButtonAriaLabel', 'euiGlobalToastList.clearAllToastsButtonDisplayText'],
        defaults: ['Clear all toast notifications', 'Clear all']
      }, function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          clearAllToastsButtonAriaLabel = _ref3[0],
          clearAllToastsButtonDisplayText = _ref3[1];
        return ___EmotionJSX(EuiGlobalToastListItem, {
          isDismissed: false
        }, ___EmotionJSX(EuiButton, {
          fill: true,
          color: "text",
          onClick: function onClick() {
            toasts.forEach(function (toast) {
              return dismissToastProp(toast);
            });
            onClearAllToasts === null || onClearAllToasts === void 0 || onClearAllToasts();
          },
          css: styles.euiGlobalToastListDismissButton,
          "aria-label": clearAllToastsButtonAriaLabel,
          "data-test-subj": "euiClearAllToastsButton"
        }, clearAllToastsButtonDisplayText));
      });
    }
  }, [showClearAllButtonAt, onClearAllToasts, toasts, dismissToastProp, styles]);
  var classes = classNames('euiGlobalToastList', className);
  return ___EmotionJSX("div", _extends({
    "aria-live": "polite",
    role: "log",
    ref: listElement,
    css: cssStyles,
    className: classes
  }, rest), renderedToasts, clearAllButton);
};