import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["title", "color", "iconType", "onClose", "children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiButtonIcon } from '../button';
import { EuiI18n } from '../i18n';
import { EuiIcon } from '../icon';
import { EuiText } from '../text';
import { euiToastStyles, euiToastHeaderStyles } from './toast.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['primary', 'success', 'warning', 'danger'];
export var EuiToast = function EuiToast(_ref) {
  var title = _ref.title,
    color = _ref.color,
    iconType = _ref.iconType,
    onClose = _ref.onClose,
    children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var baseStyles = useEuiMemoizedStyles(euiToastStyles);
  var baseCss = [baseStyles.euiToast, color && baseStyles[color]];
  var headerStyles = useEuiMemoizedStyles(euiToastHeaderStyles);
  var headerCss = [headerStyles.euiToastHeader, children && headerStyles.withBody];
  var classes = classNames('euiToast', className);
  return ___EmotionJSX("div", _extends({
    css: baseCss,
    className: classes
  }, rest), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
    token: "euiToast.newNotification",
    default: "A new notification appears"
  }))), ___EmotionJSX(EuiI18n, {
    token: "euiToast.notification",
    default: "Notification"
  }, function (notification) {
    return ___EmotionJSX("div", {
      css: headerCss,
      "aria-label": notification,
      "data-test-subj": "euiToastHeader"
    }, iconType && ___EmotionJSX(EuiIcon, {
      css: headerStyles.euiToastHeader__icon,
      type: iconType,
      size: "m",
      "aria-hidden": "true"
    }), ___EmotionJSX("span", {
      css: headerStyles.euiToastHeader__title,
      "data-test-subj": "euiToastHeader__title"
    }, title));
  }), onClose && ___EmotionJSX(EuiI18n, {
    token: "euiToast.dismissToast",
    default: "Dismiss toast"
  }, function (dismissToast) {
    return ___EmotionJSX(EuiButtonIcon, {
      css: baseStyles.euiToast__closeButton,
      iconType: "cross",
      color: "text",
      size: "xs",
      "aria-label": dismissToast,
      onClick: onClose,
      "data-test-subj": "toastCloseButton"
    });
  }), children && ___EmotionJSX(EuiText, {
    size: "s",
    "data-test-subj": "euiToastBody"
  }, children));
};