/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiTextBreakWord, logicalCSS } from '../../global_styling';
import { euiShadowLarge } from '../../themes/amsterdam';
import { euiTitle } from '../title/title.styles';
export var euiToastStyles = function euiToastStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiToast: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";", euiShadowLarge(euiThemeContext), " position:relative;", logicalCSS('padding-horizontal', euiTheme.size.base), " ", logicalCSS('padding-vertical', euiTheme.size.base), " background-color:", euiTheme.colors.emptyShade, ";", logicalCSS('width', '100%'), " ", euiTextBreakWord(), "&:hover,&:focus{[class*='euiToast__closeButton']{opacity:1;}};label:euiToast;"),
    // Elements
    euiToast__closeButton: /*#__PURE__*/css("position:absolute;", logicalCSS('top', euiTheme.size.base), " ", logicalCSS('right', euiTheme.size.base), ";;label:euiToast__closeButton;"),
    // Variants
    primary: /*#__PURE__*/css(logicalCSS('border-top', "2px solid ".concat(euiTheme.colors.primary)), ";;label:primary;"),
    success: /*#__PURE__*/css(logicalCSS('border-top', "2px solid ".concat(euiTheme.colors.success)), ";;label:success;"),
    warning: /*#__PURE__*/css(logicalCSS('border-top', "2px solid ".concat(euiTheme.colors.warning)), ";;label:warning;"),
    danger: /*#__PURE__*/css(logicalCSS('border-top', "2px solid ".concat(euiTheme.colors.danger)), ";;label:danger;")
  };
};
export var euiToastHeaderStyles = function euiToastHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiToastHeader: /*#__PURE__*/css("display:flex;align-items:baseline;", logicalCSS('padding-right', euiTheme.size.l), ">*+*{", logicalCSS('margin-left', euiTheme.size.s), ";};label:euiToastHeader;"),
    // Elements
    euiToastHeader__icon: /*#__PURE__*/css("flex:0 0 auto;fill:", euiTheme.colors.title, ";transform:translateY(2px);;label:euiToastHeader__icon;"),
    euiToastHeader__title: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.bold, ";;label:euiToastHeader__title;"),
    // Variants
    withBody: /*#__PURE__*/css(logicalCSS('margin-bottom', euiTheme.size.s), ";;label:withBody;")
  };
};