import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["iconType", "color", "fill", "shape", "size", "style", "className", "title", "aria-label", "aria-labelledby", "aria-describedby"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme, isColorDark, hexToRgb } from '../../services';
import { EuiIcon } from '../icon';
import { TOKEN_MAP } from './token_map';
import { COLORS } from './token_types';
import { euiTokenStyles } from './token.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var isTokenColor = function isTokenColor(color) {
  return COLORS.includes(color);
};
export var EuiToken = function EuiToken(_ref) {
  var iconType = _ref.iconType,
    color = _ref.color,
    fill = _ref.fill,
    shape = _ref.shape,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$style = _ref.style,
    style = _ref$style === void 0 ? {} : _ref$style,
    className = _ref.className,
    title = _ref.title,
    ariaLabel = _ref['aria-label'],
    ariaLabelledby = _ref['aria-labelledby'],
    ariaDescribedby = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set the icon size to the same as the passed size
  // unless they passed `xs` which IconSize doesn't support
  var finalSize = size === 'xs' ? 's' : size;

  // When displaying at the small size, the token specific icons
  // should actually be displayed at medium size
  if (typeof iconType === 'string' && iconType.indexOf('token') === 0 && size === 's') {
    finalSize = 'm';
  }

  // If the iconType passed is one of the prefab token types,
  // grab its properties
  var tokenDefaults = typeof iconType === 'string' && iconType in TOKEN_MAP ? TOKEN_MAP[iconType] : {};
  var finalColor = color || tokenDefaults.color || 'gray';
  var finalShape = shape || tokenDefaults.shape || 'circle';
  var finalFill = fill || 'light';
  var euiTheme = useEuiTheme();
  var styles = euiTokenStyles(euiTheme, finalFill);
  var cssStyles = [styles.euiToken, styles[finalShape], styles[finalFill], styles[size]];
  var finalStyle = style;
  if (isTokenColor(finalColor)) {
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles[finalColor]]);
  } else if (finalFill === 'none') {
    // When a custom HEX color is passed and the token doesn't have any fill (no background),
    // the icon gets that passed color
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles.customColor]);
    finalStyle = _objectSpread({
      color: finalColor
    }, style);
  } else {
    // When a custom HEX color is passed and the token has a fill (light or dark),
    // the background gets the custom color and the icon gets white or black based on the passed color
    // The fill='light' (lightened background) will always be overridden by fill='dark' (opaque background)
    // to better handle custom colors
    var isFinalColorDark = isColorDark.apply(void 0, _toConsumableArray(hexToRgb(finalColor)));
    var lightOrDarkColor = isFinalColorDark ? '#FFFFFF' : '#000000';
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles.customColor]);
    finalFill = 'dark';
    finalStyle = _objectSpread({
      color: lightOrDarkColor,
      backgroundColor: finalColor
    }, style);
  }
  var classes = classNames('euiToken', className);
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    style: finalStyle
  }, rest), ___EmotionJSX(EuiIcon, {
    type: iconType,
    size: finalSize,
    title: title,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby,
    "aria-describedby": ariaDescribedby
  }));
};