import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "anchorClassName", "anchorProps", "content", "title", "delay", "display", "repositionOnScroll"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { findPopoverPosition, htmlIdGenerator, keys } from '../../services';
import { enqueueStateChange } from '../../services/react';
import { EuiResizeObserver } from '../observer/resize_observer';
import { EuiPortal } from '../portal';
import { EuiToolTipPopover } from './tool_tip_popover';
import { EuiToolTipAnchor } from './tool_tip_anchor';
import { EuiToolTipArrow } from './tool_tip_arrow';
import { toolTipManager } from './tool_tip_manager';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var POSITIONS = ['top', 'right', 'bottom', 'left'];
var DISPLAYS = ['inlineBlock', 'block'];
var delayToMsMap = {
  regular: 250,
  long: 250 * 5
};
var DEFAULT_TOOLTIP_STYLES = {
  // position the tooltip content near the top-left
  // corner of the window so it can't create scrollbars
  // 50,50 because who knows what negative margins, padding, etc
  top: 50,
  left: 50,
  // just in case, avoid any potential flicker by hiding
  // the tooltip before it is positioned
  opacity: 0,
  // prevent accidental mouse interaction while positioning
  visibility: 'hidden'
};
export var EuiToolTip = /*#__PURE__*/function (_Component) {
  function EuiToolTip() {
    var _this;
    _classCallCheck(this, EuiToolTip);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiToolTip, [].concat(args));
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "anchor", null);
    _defineProperty(_this, "popover", null);
    _defineProperty(_this, "timeoutId", void 0);
    _defineProperty(_this, "state", {
      visible: false,
      hasFocus: false,
      calculatedPosition: _this.props.position,
      toolTipStyles: DEFAULT_TOOLTIP_STYLES,
      arrowStyles: undefined,
      id: _this.props.id || htmlIdGenerator()()
    });
    _defineProperty(_this, "clearAnimationTimeout", function () {
      if (_this.timeoutId) {
        _this.timeoutId = clearTimeout(_this.timeoutId);
      }
    });
    _defineProperty(_this, "testAnchor", function () {
      // when the tooltip is visible, this checks if the anchor is still part of document
      // this fixes when the react root is removed from the dom without unmounting
      // https://github.com/elastic/eui/issues/1105
      if (document.body.contains(_this.anchor) === false) {
        // the anchor is no longer part of `document`
        _this.hideToolTip();
      } else {
        if (_this.state.visible) {
          // if still visible, keep checking
          requestAnimationFrame(_this.testAnchor);
        }
      }
    });
    _defineProperty(_this, "setAnchorRef", function (ref) {
      return _this.anchor = ref;
    });
    _defineProperty(_this, "setPopoverRef", function (ref) {
      return _this.popover = ref;
    });
    _defineProperty(_this, "showToolTip", function () {
      if (!_this.timeoutId) {
        _this.timeoutId = setTimeout(function () {
          enqueueStateChange(function () {
            _this.setState({
              visible: true
            });
            toolTipManager.registerTooltip(_this.hideToolTip);
          });
        }, delayToMsMap[_this.props.delay]);
      }
    });
    _defineProperty(_this, "positionToolTip", function () {
      var requestedPosition = _this.props.position;
      if (!_this.anchor || !_this.popover) {
        return;
      }
      var _findPopoverPosition = findPopoverPosition({
          anchor: _this.anchor,
          popover: _this.popover,
          position: requestedPosition,
          offset: 16,
          // offset popover 16px from the anchor
          arrowConfig: {
            arrowWidth: 12,
            arrowBuffer: 4
          }
        }),
        position = _findPopoverPosition.position,
        left = _findPopoverPosition.left,
        top = _findPopoverPosition.top,
        arrow = _findPopoverPosition.arrow;

      // If encroaching the right edge of the window:
      // When `props.content` changes and is longer than `prevProps.content`, the tooltip width remains and
      // the resizeObserver callback will fire twice (once for vertical resize caused by text line wrapping,
      // once for a subsequent position correction) and cause a flash rerender and reposition.
      // To prevent this, we can orient from the right so that text line wrapping does not occur, negating
      // the second resizeObserver callback call.
      var windowWidth = document.documentElement.clientWidth || window.innerWidth;
      var useRightValue = windowWidth / 2 < left;
      var toolTipStyles = {
        top: top,
        left: useRightValue ? 'auto' : left,
        right: useRightValue ? windowWidth - left - _this.popover.offsetWidth : 'auto'
      };
      _this.setState({
        visible: true,
        calculatedPosition: position,
        toolTipStyles: toolTipStyles,
        arrowStyles: arrow
      });
    });
    _defineProperty(_this, "hideToolTip", function () {
      _this.clearAnimationTimeout();
      enqueueStateChange(function () {
        if (_this._isMounted) {
          _this.setState({
            visible: false,
            toolTipStyles: DEFAULT_TOOLTIP_STYLES,
            arrowStyles: undefined
          });
          toolTipManager.deregisterToolTip(_this.hideToolTip);
        }
      });
    });
    _defineProperty(_this, "onFocus", function () {
      _this.setState({
        hasFocus: true
      });
      _this.showToolTip();
    });
    _defineProperty(_this, "onBlur", function () {
      _this.setState({
        hasFocus: false
      });
      _this.hideToolTip();
    });
    _defineProperty(_this, "onEscapeKey", function (event) {
      if (event.key === keys.ESCAPE) {
        if (_this.state.visible) event.stopPropagation();
        _this.setState({
          hasFocus: false
        }); // Allows mousing over back into the tooltip to work correctly
        _this.hideToolTip();
      }
    });
    _defineProperty(_this, "onMouseOut", function (event) {
      // Prevent mousing over children from hiding the tooltip by testing for whether the mouse has
      // left the anchor for a non-child.
      if (_this.anchor === event.relatedTarget || _this.anchor != null && !_this.anchor.contains(event.relatedTarget)) {
        if (!_this.state.hasFocus) {
          _this.hideToolTip();
        }
      }
      if (_this.props.onMouseOut) {
        _this.props.onMouseOut(event);
      }
    });
    return _this;
  }
  _inherits(EuiToolTip, _Component);
  return _createClass(EuiToolTip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.repositionOnScroll) {
        window.addEventListener('scroll', this.positionToolTip, true);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearAnimationTimeout();
      this._isMounted = false;
      window.removeEventListener('scroll', this.positionToolTip, true);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.visible === false && this.state.visible === true) {
        requestAnimationFrame(this.testAnchor);
      }

      // update scroll listener
      if (prevProps.repositionOnScroll !== this.props.repositionOnScroll) {
        if (this.props.repositionOnScroll) {
          window.addEventListener('scroll', this.positionToolTip, true);
        } else {
          window.removeEventListener('scroll', this.positionToolTip, true);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        anchorClassName = _this$props.anchorClassName,
        anchorProps = _this$props.anchorProps,
        content = _this$props.content,
        title = _this$props.title,
        delay = _this$props.delay,
        display = _this$props.display,
        repositionOnScroll = _this$props.repositionOnScroll,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var _this$state = this.state,
        arrowStyles = _this$state.arrowStyles,
        id = _this$state.id,
        toolTipStyles = _this$state.toolTipStyles,
        visible = _this$state.visible,
        calculatedPosition = _this$state.calculatedPosition;
      var classes = classNames('euiToolTip', className);
      var anchorClasses = classNames(anchorClassName, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.className);
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiToolTipAnchor, _extends({}, anchorProps, {
        ref: this.setAnchorRef,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        onKeyDown: this.onEscapeKey,
        onMouseOver: this.showToolTip,
        onMouseOut: this.onMouseOut,
        id: id,
        className: anchorClasses,
        display: display,
        isVisible: visible
      }), children), visible && (content || title) && ___EmotionJSX(EuiPortal, null, ___EmotionJSX(EuiToolTipPopover, _extends({
        className: classes,
        style: toolTipStyles,
        positionToolTip: this.positionToolTip,
        popoverRef: this.setPopoverRef,
        title: title,
        id: id,
        role: "tooltip",
        calculatedPosition: calculatedPosition
      }, rest), ___EmotionJSX(EuiToolTipArrow, {
        style: arrowStyles,
        className: "euiToolTip__arrow",
        position: calculatedPosition
      }), ___EmotionJSX(EuiResizeObserver, {
        onResize: this.positionToolTip
      }, function (resizeRef) {
        return ___EmotionJSX("div", {
          ref: resizeRef
        }, content);
      }))));
    }
  }]);
}(Component);
_defineProperty(EuiToolTip, "defaultProps", {
  position: 'top',
  delay: 'regular',
  display: 'inlineBlock'
});