import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["onBlur", "onFocus", "onMouseOver", "onMouseOut", "id", "className", "children", "display", "isVisible"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, forwardRef } from 'react';
import classNames from 'classnames';
import { euiToolTipAnchorStyles } from './tool_tip.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiToolTipAnchor = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var _onBlur = _ref.onBlur,
    _onFocus = _ref.onFocus,
    onMouseOver = _ref.onMouseOver,
    onMouseOut = _ref.onMouseOut,
    id = _ref.id,
    className = _ref.className,
    children = _ref.children,
    display = _ref.display,
    isVisible = _ref.isVisible,
    rest = _objectWithoutProperties(_ref, _excluded);
  var anchorCss = euiToolTipAnchorStyles();
  var cssStyles = [anchorCss.euiToolTipAnchor, anchorCss[display]];
  var classes = classNames('euiToolTipAnchor', className);
  return (
    // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
    ___EmotionJSX("span", _extends({
      ref: ref,
      css: cssStyles
    }, rest, {
      className: classes,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), /*#__PURE__*/cloneElement(children, {
      onFocus: function onFocus(e) {
        _onFocus();
        children.props.onFocus && children.props.onFocus(e);
      },
      onBlur: function onBlur(e) {
        _onBlur();
        children.props.onBlur && children.props.onBlur(e);
      },
      'aria-describedby': isVisible ? classNames(id, children.props['aria-describedby']) : children.props['aria-describedby']
    }))
  );
});
EuiToolTipAnchor.displayName = 'EuiToolTipAnchor';