import _createClass from "@babel/runtime/helpers/createClass";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Manager utility that ensures only one tooltip is visible at a time
 *
 * UX rationale (primarily for mouse-only users):
 * @see https://github.com/elastic/kibana/issues/144482
 * @see https://github.com/elastic/eui/issues/5883
 */
var ToolTipManager = /*#__PURE__*/_createClass(function ToolTipManager() {
  var _this = this;
  _classCallCheck(this, ToolTipManager);
  // We use a set instead of a single var just in case
  // multiple tooltips are registered via async shenanigans
  _defineProperty(this, "toolTipsToHide", new Set());
  _defineProperty(this, "registerTooltip", function (hideCallback) {
    _this.toolTipsToHide.forEach(function (hide) {
      return hide();
    });
    _this.toolTipsToHide.clear();
    _this.toolTipsToHide.add(hideCallback);
  });
  _defineProperty(this, "deregisterToolTip", function (hideCallback) {
    _this.toolTipsToHide.delete(hideCallback);
  });
});
export var toolTipManager = new ToolTipManager();