import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "title", "className", "positionToolTip", "popoverRef", "calculatedPosition"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useRef, useCallback } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiToolTipStyles } from './tool_tip.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiToolTipPopover = function EuiToolTipPopover(_ref) {
  var children = _ref.children,
    title = _ref.title,
    className = _ref.className,
    positionToolTip = _ref.positionToolTip,
    popoverRef = _ref.popoverRef,
    calculatedPosition = _ref.calculatedPosition,
    rest = _objectWithoutProperties(_ref, _excluded);
  var popover = useRef();
  var euiTheme = useEuiTheme();
  var styles = euiToolTipStyles(euiTheme);
  var cssStyles = [styles.euiToolTip, calculatedPosition && styles[calculatedPosition]];
  var updateDimensions = useCallback(function () {
    requestAnimationFrame(function () {
      // Because of this delay, sometimes `positionToolTip` becomes unavailable.
      if (popover.current) {
        positionToolTip();
      }
    });
  }, [positionToolTip]);
  var setPopoverRef = function setPopoverRef(ref) {
    if (popoverRef) {
      popoverRef(ref);
    }
  };
  useEffect(function () {
    document.body.classList.add('euiBody-hasPortalContent');
    window.addEventListener('resize', updateDimensions);
    return function () {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', updateDimensions);
    };
  }, [updateDimensions]);
  var classes = classNames('euiToolTipPopover', className);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes,
    ref: setPopoverRef,
    "data-position": calculatedPosition
  }, rest), title && ___EmotionJSX("div", {
    css: styles.euiToolTip__title,
    className: "euiToolTip__title"
  }, title), children);
};